/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.event.mouse;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseContextImpl;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.context.TargetStackUtil;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.Mouseable;
import java.util.LinkedList;
import java.util.List;

public abstract class MouseWrapper<E> {
    protected GlimpseCanvas canvas;
    protected LinkedList<GlimpseTargetStack> dragHoveredSet;
    protected LinkedList<GlimpseTargetStack> hoveredSet;

    public MouseWrapper(GlimpseCanvas canvas) {
        this.canvas = canvas;
        this.dragHoveredSet = new LinkedList();
        this.hoveredSet = new LinkedList();
    }

    public List<GlimpseTargetStack> getContainingTargets(E e) {
        GlimpseContextImpl context = new GlimpseContextImpl(this.canvas);
        LinkedList<GlimpseTargetStack> result = new LinkedList<GlimpseTargetStack>();
        this.getContainingTargets(e, context, result);
        return result;
    }

    protected boolean getContainingTargets(E e, GlimpseContext context, List<GlimpseTargetStack> accumulator) {
        GlimpseTargetStack stack = context.getTargetStack();
        GlimpseTarget layout = stack.getTarget();
        GlimpseBounds bounds = stack.getBounds();
        List<GlimpseTarget> list = layout.getTargetChildren();
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            GlimpseTarget childLayout = list.get(i);
            GlimpseBounds childBounds = childLayout.getTargetBounds(context.getTargetStack());
            stack.push(childLayout, childBounds);
            boolean consumeEvent = this.getContainingTargets(e, context, accumulator);
            if (consumeEvent) {
                return true;
            }
            stack.pop();
        }
        if (!layout.isEventConsumer() && !layout.isEventGenerator()) {
            return false;
        }
        if (this.handleInterior(e, context, bounds)) {
            if (layout.isEventGenerator()) {
                accumulator.add(TargetStackUtil.newTargetStack(stack));
            }
            return layout.isEventConsumer();
        }
        return false;
    }

    protected boolean handleInterior(E e, GlimpseContext context, GlimpseBounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (!this.isValid(e, bounds)) {
            return false;
        }
        boolean isButtonDown = this.isButtonDown(e);
        boolean isInterior = this.isInterior(e, bounds);
        if (isInterior) {
            this.addHovered(context.getTargetStack());
            if (!isButtonDown) {
                this.addDragHovered(context.getTargetStack());
            }
        }
        return isInterior;
    }

    protected Mouseable getMouseTarget(GlimpseTargetStack stack) {
        if (stack == null) {
            return null;
        }
        GlimpseTarget target = stack.getTarget();
        if (target == null || !(target instanceof Mouseable)) {
            return null;
        }
        Mouseable mouseTarget = (Mouseable)((Object)target);
        return mouseTarget;
    }

    protected List<GlimpseTargetStack> clearAllHovered() {
        List<GlimpseTargetStack> oldHovered = this.copyHovered();
        this.dragHoveredSet.clear();
        this.hoveredSet.clear();
        return oldHovered;
    }

    protected void setAllHovered(List<GlimpseTargetStack> list) {
        this.setDragHovered(list);
        this.setHovered(list);
    }

    protected List<GlimpseTargetStack> clearDragHovered() {
        List<GlimpseTargetStack> oldHovered = this.copyDragHovered();
        this.dragHoveredSet.clear();
        return oldHovered;
    }

    protected void addDragHovered(GlimpseTargetStack stack) {
        this.dragHoveredSet.add(TargetStackUtil.newTargetStack(stack));
    }

    protected void setDragHovered(List<GlimpseTargetStack> list) {
        this.clearDragHovered();
        for (GlimpseTargetStack stack : list) {
            this.addDragHovered(stack);
        }
    }

    protected boolean isDragHovered() {
        return this.dragHoveredSet != null && !this.dragHoveredSet.isEmpty();
    }

    protected List<GlimpseTargetStack> copyDragHovered() {
        return new LinkedList<GlimpseTargetStack>(this.dragHoveredSet);
    }

    protected List<GlimpseTargetStack> getDragHovered() {
        return this.dragHoveredSet;
    }

    protected List<GlimpseTargetStack> clearHovered() {
        List<GlimpseTargetStack> oldHovered = this.copyHovered();
        this.hoveredSet.clear();
        return oldHovered;
    }

    protected void addHovered(GlimpseTargetStack stack) {
        this.hoveredSet.add(TargetStackUtil.newTargetStack(stack));
    }

    protected void setHovered(List<GlimpseTargetStack> list) {
        this.clearHovered();
        for (GlimpseTargetStack stack : list) {
            this.addHovered(stack);
        }
    }

    protected boolean isHovered() {
        return this.hoveredSet != null && !this.hoveredSet.isEmpty();
    }

    protected List<GlimpseTargetStack> copyHovered() {
        return new LinkedList<GlimpseTargetStack>(this.hoveredSet);
    }

    protected List<GlimpseTargetStack> getHovered() {
        return this.hoveredSet;
    }

    protected GlimpseMouseEvent toLocalGlimpseEvent(E e, GlimpseTargetStack stack) {
        return this.toGlimpseEvent(this.toLocalCoords(e, stack));
    }

    protected GlimpseMouseEvent toLocalGlimpseEvent(E e, GlimpseTargetStack stack, boolean handled) {
        GlimpseMouseEvent event = this.toLocalGlimpseEvent(e, stack);
        event.setHandled(handled);
        return event;
    }

    protected abstract boolean isButtonDown(E var1);

    protected abstract boolean isInterior(E var1, GlimpseBounds var2);

    protected abstract boolean isValid(E var1, GlimpseBounds var2);

    protected abstract E toLocalCoords(E var1, GlimpseTargetStack var2);

    protected abstract GlimpseMouseEvent toGlimpseEvent(E var1);

    public void notifyMouseEnteredExited(E event, List<GlimpseTargetStack> oldStacks, List<GlimpseTargetStack> newStacks) {
        for (GlimpseTargetStack oldStack : oldStacks) {
            if (newStacks.contains(oldStack)) continue;
            this.notifyMouseExited(event, oldStack);
        }
        for (GlimpseTargetStack newStack : newStacks) {
            if (oldStacks.contains(newStack)) continue;
            this.notifyMouseEntered(event, newStack);
        }
    }

    public void notifyMouseEntered(E event, GlimpseTargetStack stack) {
        Mouseable mouseTarget = this.getMouseTarget(stack);
        GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, stack);
        if (mouseTarget != null) {
            mouseTarget.mouseEntered(glimpseEvent);
        }
    }

    public void notifyMouseEntered(E event, List<GlimpseTargetStack> stacks) {
        for (GlimpseTargetStack stack : stacks) {
            this.notifyMouseEntered(event, stack);
        }
    }

    public void notifyMouseExited(E event, GlimpseTargetStack stack) {
        Mouseable mouseTarget = this.getMouseTarget(stack);
        GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, stack);
        if (mouseTarget != null) {
            mouseTarget.mouseExited(glimpseEvent);
        }
    }

    public void notifyMouseExited(E event, List<GlimpseTargetStack> stacks) {
        for (GlimpseTargetStack stack : stacks) {
            this.notifyMouseExited(event, stack);
        }
    }
}

