/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.context;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class GlimpseTargetStackImpl
implements GlimpseTargetStack {
    private final LinkedList<GlimpseTarget> targetStack = new LinkedList();
    private final List<GlimpseTarget> targetStackUnmod = Collections.unmodifiableList(this.targetStack);
    private final LinkedList<GlimpseBounds> boundStack = new LinkedList();
    private final List<GlimpseBounds> boundStackUnmod = Collections.unmodifiableList(this.boundStack);

    public GlimpseTargetStackImpl(GlimpseTarget ... targets) {
        for (GlimpseTarget target : targets) {
            this.push(target);
        }
    }

    public GlimpseTargetStackImpl(GlimpseCanvas canvas) {
        this.push(canvas, canvas.getTargetBounds());
    }

    @Override
    public GlimpseTargetStack push(GlimpseTarget target, GlimpseBounds bounds) {
        this.targetStack.push(target);
        this.boundStack.push(bounds);
        return this;
    }

    @Override
    public GlimpseTargetStack push(GlimpseTarget target) {
        GlimpseBounds bounds = target.getTargetBounds(this);
        if (bounds == null) {
            bounds = new GlimpseBounds(0, 0, 0, 0);
        }
        this.targetStack.push(target);
        this.boundStack.push(bounds);
        return this;
    }

    @Override
    public GlimpseTargetStack push(GlimpseTargetStack stack) {
        List<GlimpseTarget> targetList = stack.getTargetList();
        ListIterator<GlimpseTarget> targetIter = targetList.listIterator(targetList.size());
        List<GlimpseBounds> boundsList = stack.getBoundsList();
        ListIterator<GlimpseBounds> boundsIter = boundsList.listIterator(boundsList.size());
        while (targetIter.hasPrevious()) {
            this.push(targetIter.previous(), boundsIter.previous());
        }
        return this;
    }

    @Override
    public GlimpseTargetStack pop() {
        this.targetStack.pop();
        this.boundStack.pop();
        return this;
    }

    @Override
    public GlimpseTarget getTarget() {
        return this.targetStack.peek();
    }

    @Override
    public GlimpseBounds getBounds() {
        return this.boundStack.peek();
    }

    @Override
    public List<GlimpseTarget> getTargetList() {
        return this.targetStackUnmod;
    }

    @Override
    public List<GlimpseBounds> getBoundsList() {
        return this.boundStackUnmod;
    }

    @Override
    public int getSize() {
        return this.targetStack.size();
    }

    public int hashCode() {
        return this.targetStack.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlimpseTargetStackImpl other = (GlimpseTargetStackImpl)obj;
        return !(this.targetStack == null ? other.targetStack != null : !this.targetStack.equals(other.targetStack));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        Iterator targetIter = this.targetStack.iterator();
        Iterator boundsIter = this.boundStack.iterator();
        while (targetIter.hasNext()) {
            GlimpseTarget target = (GlimpseTarget)targetIter.next();
            GlimpseBounds bounds = (GlimpseBounds)boundsIter.next();
            b.append(String.format("[%s,%s],", target, bounds));
        }
        if (this.targetStack.isEmpty()) {
            b.setLength(b.length() - 1);
        }
        b.append("]");
        return b.toString();
    }
}

