/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.canvas;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.canvas.LayoutManager;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseContextImpl;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.swing.MouseWrapperSwing;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.List;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.swing.JPanel;

public class SwingGlimpseCanvas
extends JPanel
implements GlimpseCanvas {
    private static final Logger logger = Logger.getLogger(SwingGlimpseCanvas.class.getName());
    private static final long serialVersionUID = -5279064113986688397L;
    protected GLCanvas glCanvas;
    protected GLAutoDrawable tempDrawable;
    protected LayoutManager layoutManager;
    protected MouseWrapperSwing mouseHelper;
    protected boolean isEventConsumer = true;
    protected boolean isEventGenerator = true;
    protected boolean isDisposed = false;

    public SwingGlimpseCanvas() {
        this(true);
    }

    public SwingGlimpseCanvas(GLContext _context) {
        this(true, _context);
    }

    public SwingGlimpseCanvas(boolean setNoEraseBackgroundProperty) {
        this(setNoEraseBackgroundProperty, null);
    }

    public SwingGlimpseCanvas(boolean setNoEraseBackgroundProperty, GLContext _context) {
        if (setNoEraseBackgroundProperty) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        this.glCanvas = _context == null ? new GLCanvas() : new GLCanvas(null, null, _context, null);
        this.mouseHelper = new MouseWrapperSwing(this);
        this.addMouseListener(this.mouseHelper);
        this.addMouseMotionListener(this.mouseHelper);
        this.addMouseWheelListener(this.mouseHelper);
        this.layoutManager = new LayoutManager();
        this.setLayout(new BorderLayout());
        this.add((Component)this.glCanvas, "Center");
        this.setMinimumSize(new Dimension(0, 0));
        this.isDisposed = false;
        this.addGLEventListener((GLAutoDrawable)this.glCanvas);
    }

    @Override
    public GlimpseContext getGlimpseContext() {
        return new GlimpseContextImpl(this);
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        for (GlimpseLayout target : this.layoutManager.getLayoutList()) {
            target.setLookAndFeel(laf);
        }
    }

    @Override
    public void addLayout(GlimpseLayout layout) {
        this.layoutManager.addLayout(layout);
    }

    @Override
    public void addLayout(GlimpseLayout layout, int zOrder) {
        this.layoutManager.addLayout(layout, zOrder);
    }

    @Override
    public void setZOrder(GlimpseLayout layout, int zOrder) {
        this.layoutManager.setZOrder(layout, zOrder);
    }

    @Override
    public void removeLayout(GlimpseLayout layout) {
        this.layoutManager.removeLayout(layout);
    }

    @Override
    public void removeAllLayouts() {
        this.layoutManager.removeAllLayouts();
    }

    @Override
    public List<GlimpseTarget> getTargetChildren() {
        return this.layoutManager.getLayoutList();
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.glCanvas.addMouseListener(listener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener listener) {
        this.glCanvas.addMouseMotionListener(listener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener listener) {
        this.glCanvas.addMouseWheelListener(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.glCanvas.removeMouseListener(listener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.glCanvas.removeMouseMotionListener(listener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.glCanvas.removeMouseWheelListener(listener);
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.glCanvas.addKeyListener(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.glCanvas.removeKeyListener(listener);
    }

    public Dimension getDimension() {
        return this.glCanvas.getSize();
    }

    @Override
    public GlimpseBounds getTargetBounds(GlimpseTargetStack stack) {
        return new GlimpseBounds(this.getDimension());
    }

    @Override
    public GlimpseBounds getTargetBounds() {
        return this.getTargetBounds(null);
    }

    @Override
    public void paint() {
        this.glCanvas.display();
    }

    @Override
    public GLContext getGLContext() {
        return this.glCanvas.getContext();
    }

    @Override
    public String toString() {
        return SwingGlimpseCanvas.class.getSimpleName();
    }

    @Override
    public boolean isEventConsumer() {
        return this.isEventConsumer;
    }

    @Override
    public void setEventConsumer(boolean consume) {
        this.isEventConsumer = consume;
    }

    @Override
    public boolean isEventGenerator() {
        return this.isEventGenerator;
    }

    @Override
    public void setEventGenerator(boolean generate) {
        this.isEventGenerator = generate;
    }

    @Override
    public void removeNotify() {
        if (this.tempDrawable == null) {
            this.tempDrawable = GLDrawableFactory.getFactory().createGLPbuffer(this.glCanvas.getChosenGLCapabilities(), null, 10, 10, this.glCanvas.getContext());
        }
        this.attachAllGLListeners(this.tempDrawable);
        this.tempDrawable.display();
        boolean autoSwap = this.glCanvas.getAutoSwapBufferMode();
        this.remove((Component)this.glCanvas);
        super.removeNotify();
        this.glCanvas = new GLCanvas(this.tempDrawable.getChosenGLCapabilities(), null, this.tempDrawable.getContext(), null);
        this.glCanvas.setAutoSwapBufferMode(autoSwap);
        this.attachAllGLListeners((GLAutoDrawable)this.glCanvas);
        this.add((Component)this.glCanvas, "Center");
    }

    private void attachAllGLListeners(GLAutoDrawable drawable) {
        this.addMouseListener(this.mouseHelper);
        this.addMouseMotionListener(this.mouseHelper);
        this.addMouseWheelListener(this.mouseHelper);
        this.addGLEventListener(drawable);
    }

    private void addGLEventListener(GLAutoDrawable drawable) {
        drawable.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable drawable) {
                try {
                    GL gl = drawable.getGL();
                    gl.setSwapInterval(0);
                }
                catch (Exception e) {
                    LoggerUtils.logWarning((Logger)logger, (String)"Trouble in init.", (Throwable)e, (Object[])new Object[0]);
                }
            }

            public void display(GLAutoDrawable drawable) {
                for (GlimpseLayout layout : SwingGlimpseCanvas.this.layoutManager.getLayoutList()) {
                    layout.paintTo(SwingGlimpseCanvas.this.getGlimpseContext());
                }
            }

            public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
                for (GlimpseLayout layout : SwingGlimpseCanvas.this.layoutManager.getLayoutList()) {
                    layout.layoutTo(SwingGlimpseCanvas.this.getGlimpseContext());
                }
            }

            public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose(RepaintManager manager) {
        Runnable dispose = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GLContext glContext = SwingGlimpseCanvas.this.getGLContext();
                GlimpseContextImpl context = new GlimpseContextImpl(glContext);
                glContext.makeCurrent();
                try {
                    for (GlimpseLayout layout : SwingGlimpseCanvas.this.layoutManager.getLayoutList()) {
                        layout.dispose(context);
                    }
                }
                finally {
                    glContext.release();
                }
                SwingGlimpseCanvas.this.isDisposed = true;
            }
        };
        if (manager != null) {
            manager.asyncExec(dispose);
        } else {
            dispose.run();
        }
    }
}

