/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.canvas;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.canvas.LayoutManager;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseContextImpl;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.gl.GLListenerInfo;
import com.metsci.glimpse.gl.GLSimpleListener;
import com.metsci.glimpse.gl.GLSimplePixelBuffer;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class OffscreenGlimpseCanvas
implements GlimpseCanvas {
    private static final Logger logger = Logger.getLogger(OffscreenGlimpseCanvas.class.getName());
    protected GLSimplePixelBuffer pixelBuffer;
    protected boolean isDisposed;
    protected LayoutManager layoutManager;

    public OffscreenGlimpseCanvas(int width, int height) {
        this(width, height, null);
    }

    public OffscreenGlimpseCanvas(int width, int height, GLContext _context) {
        this.pixelBuffer = new GLSimplePixelBuffer(width, height, _context);
        this.isDisposed = false;
        this.layoutManager = new LayoutManager();
        this.pixelBuffer.addListener(new GLSimpleListener(){

            @Override
            public void init(GLContext context) {
                try {
                    GL gl = context.getGL();
                    gl.setSwapInterval(0);
                }
                catch (Exception e) {
                    LoggerUtils.logWarning((Logger)logger, (String)"Trouble in init.", (Throwable)e, (Object[])new Object[0]);
                }
            }

            @Override
            public void display(GLContext context) {
                for (GlimpseLayout layout : OffscreenGlimpseCanvas.this.layoutManager.getLayoutList()) {
                    layout.paintTo(OffscreenGlimpseCanvas.this.getGlimpseContext());
                }
            }

            @Override
            public void reshape(GLContext context, int x, int y, int width, int height) {
                for (GlimpseLayout layout : OffscreenGlimpseCanvas.this.layoutManager.getLayoutList()) {
                    layout.layoutTo(OffscreenGlimpseCanvas.this.getGlimpseContext());
                }
            }

            @Override
            public void displayChanged(GLContext context, boolean modeChanged, boolean deviceChanged) {
            }

            @Override
            public void dispose(GLContext context) {
            }

            @Override
            public boolean isDisposed() {
                return false;
            }

            @Override
            public GLListenerInfo getInfo() {
                return null;
            }
        });
    }

    public Dimension getDimension() {
        return this.pixelBuffer.getDimension();
    }

    public Object glSyncExec(GLSimplePixelBuffer.GLRunnable runnable) {
        return this.pixelBuffer.glSyncExec(runnable);
    }

    public BufferedImage drawToBufferedImage() {
        return this.pixelBuffer.drawToBufferedImage();
    }

    public void resize(int width, int height, boolean notifyListeners) {
        this.pixelBuffer.resize(width, height, notifyListeners);
    }

    @Override
    public GlimpseContext getGlimpseContext() {
        return new GlimpseContextImpl(this);
    }

    @Override
    public GlimpseBounds getTargetBounds(GlimpseTargetStack stack) {
        return new GlimpseBounds(this.getDimension());
    }

    @Override
    public GlimpseBounds getTargetBounds() {
        return this.getTargetBounds(null);
    }

    @Override
    public void addLayout(GlimpseLayout layout) {
        this.layoutManager.addLayout(layout);
    }

    @Override
    public void addLayout(GlimpseLayout layout, int zOrder) {
        this.layoutManager.addLayout(layout, zOrder);
    }

    @Override
    public void setZOrder(GlimpseLayout layout, int zOrder) {
        this.layoutManager.setZOrder(layout, zOrder);
    }

    @Override
    public void removeLayout(GlimpseLayout layout) {
        this.layoutManager.removeLayout(layout);
    }

    @Override
    public void removeAllLayouts() {
        this.layoutManager.removeAllLayouts();
    }

    @Override
    public List<GlimpseTarget> getTargetChildren() {
        return this.layoutManager.getLayoutList();
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        for (GlimpseLayout layout : this.layoutManager.getLayoutList()) {
            layout.setLookAndFeel(laf);
        }
    }

    @Override
    public void paint() {
        this.pixelBuffer.draw();
    }

    @Override
    public GLContext getGLContext() {
        return this.pixelBuffer.getGLContext();
    }

    public String toString() {
        return OffscreenGlimpseCanvas.class.getSimpleName();
    }

    @Override
    public boolean isEventConsumer() {
        return false;
    }

    @Override
    public void setEventConsumer(boolean consume) {
    }

    @Override
    public boolean isEventGenerator() {
        return false;
    }

    @Override
    public void setEventGenerator(boolean generate) {
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose(RepaintManager manager) {
        Runnable dispose = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GLContext glContext = OffscreenGlimpseCanvas.this.getGLContext();
                GlimpseContextImpl context = new GlimpseContextImpl(glContext);
                glContext.makeCurrent();
                try {
                    for (GlimpseLayout layout : OffscreenGlimpseCanvas.this.layoutManager.getLayoutList()) {
                        layout.dispose(context);
                    }
                    OffscreenGlimpseCanvas.this.pixelBuffer.dispose();
                    OffscreenGlimpseCanvas.this.isDisposed = true;
                }
                finally {
                    glContext.release();
                }
            }
        };
        if (manager != null) {
            manager.asyncExec(dispose);
        } else {
            dispose.run();
        }
    }
}

