/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged.shader;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.axis.tagged.shader.TaggedPointShader;
import com.metsci.glimpse.gl.shader.ShaderArg;
import com.metsci.glimpse.gl.shader.ShaderSource;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.IOException;
import java.util.List;

public class PartialTaggedPointShader
extends TaggedPointShader
implements AxisListener1D {
    private ShaderArg vertexCoordTexUnit;
    private ShaderArg textureCoordTexUnit;
    private ShaderArg sizeArg;

    public PartialTaggedPointShader(int colorTextureUnit, int sizeTextureUnit, int vertexTexUnit, int textureTexUnit, int colorAttributeIndex, int sizeAttributeIndex, TaggedAxis1D colorAxis, TaggedAxis1D sizeAxis, ShaderSource ... source) throws IOException {
        super(colorTextureUnit, sizeTextureUnit, colorAttributeIndex, sizeAttributeIndex, colorAxis, sizeAxis, source);
        this.vertexCoordTexUnit.setValue(vertexTexUnit);
        this.textureCoordTexUnit.setValue(textureTexUnit);
        this.setSizeArgValue();
        colorAxis.addAxisListener(this);
    }

    public PartialTaggedPointShader(int colorTextureUnit, int sizeTextureUnit, int vertexTexUnit, int textureTexUnit, int colorAttributeIndex, int sizeAttributeIndex, TaggedAxis1D colorAxis, TaggedAxis1D sizeAxis) throws IOException {
        this(colorTextureUnit, sizeTextureUnit, vertexTexUnit, textureTexUnit, colorAttributeIndex, sizeAttributeIndex, colorAxis, sizeAxis, PartialTaggedPointShader.readSource());
    }

    @Override
    protected void initializeShaderArgs() {
        super.initializeShaderArgs();
        this.vertexCoordTexUnit = this.getArg("vcoordtex");
        this.textureCoordTexUnit = this.getArg("tcoordtex");
        this.sizeArg = this.getArg("size");
    }

    private static final ShaderSource readSource() throws IOException {
        return new ShaderSource("shaders/point/tagged_point_shader.vs", StreamOpener.fileThenResource);
    }

    @Override
    public void axisUpdated(Axis1D axis) {
        this.setSizeArgValue();
    }

    protected void setSizeArgValue() {
        List<Tag> tags = this.taggedColorAxis.getSortedTags();
        int size = tags.size();
        int count = 0;
        for (int i = size - 1; i >= 0; --i) {
            Tag tag = tags.get(i);
            if (!tag.hasAttribute("TexCoord")) continue;
            ++count;
        }
        this.sizeArg.setValue(count);
    }
}

