/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.tagged;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class Tag {
    public static final String TEX_COORD_ATTR = "TexCoord";
    public static final Comparator<Tag> tagValueComparator = new Comparator<Tag>(){

        @Override
        public int compare(Tag tag1, Tag tag2) {
            return Double.compare(tag1.value, tag2.value);
        }
    };
    protected String name;
    protected double value;
    protected Map<String, Object> attributeMap;

    public Tag(Tag tag) {
        this.name = tag.name;
        this.value = tag.value;
        if (tag.attributeMap != null) {
            this.attributeMap = new HashMap<String, Object>();
            this.attributeMap.putAll(tag.attributeMap);
        }
    }

    public Tag(String name, double value) {
        this.name = name;
        this.value = value;
    }

    public Tag(String name) {
        this(name, 0.0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Tag setAttribute(String key, Object value) {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        this.attributeMap.put(key, value);
        return this;
    }

    public boolean hasAttribute(String key) {
        if (this.attributeMap == null) {
            return false;
        }
        return this.attributeMap.containsKey(key);
    }

    public Object getAttribute(String key) {
        if (this.attributeMap == null) {
            return null;
        }
        return this.attributeMap.get(key);
    }

    public int hashCode() {
        return 31 + (this.name == null ? 0 : this.name.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }
}

