/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter.label;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.metsci.glimpse.util.units.time.format.TimeStampFormat;
import com.metsci.glimpse.util.units.time.format.TimeStampFormatStandard;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class TimeAxisLabelHandler
implements AxisLabelHandler {
    protected static final TimeZone defaultTimeZone = TimeZone.getTimeZone("UTC");
    protected static final TimeStampFormat defaultMinuteSecondFormat = new TimeStampFormatStandard("%m:%S", defaultTimeZone);
    protected static final TimeStampFormat defaultHourDayMonthFormat = new TimeStampFormatStandard("%d %3N %H:00 ", defaultTimeZone);
    protected static final TimeStampFormat defaultHourMinuteFormat = new TimeStampFormatStandard("%H:%m", defaultTimeZone);
    protected static final TimeStampFormat defaultDayMonthYearFormat = new TimeStampFormatStandard("%d %3N %y", defaultTimeZone);
    protected static final TimeStampFormat defaultDayFormat = new TimeStampFormatStandard("%d", defaultTimeZone);
    protected static final TimeStampFormat defaultMonthYearFormat = new TimeStampFormatStandard("%3N %y", defaultTimeZone);
    protected static final TimeStampFormat defaultMonthFormat = new TimeStampFormatStandard("%3N", defaultTimeZone);
    protected static final TimeStampFormat defaultYearFormat = new TimeStampFormatStandard("%y", defaultTimeZone);
    protected static final TimeStructFactory hourStructFactory = new HourStructFactory();
    protected static final TimeStructFactory dayStructFactory = new DayStructFactory();
    protected static final TimeStructFactory monthStructFactory = new MonthStructFactory();
    protected static final TimeStructFactory yearStructFactory = new YearStructFactory();
    protected Epoch epoch;
    protected final TimeZone timeZone;
    protected final TimeStampFormat minuteSecondFormat;
    protected final TimeStampFormat hourDayMonthFormat;
    protected final TimeStampFormat hourMinuteFormat;
    protected final TimeStampFormat dayMonthYearFormat;
    protected final TimeStampFormat dayFormat;
    protected final TimeStampFormat monthFormat;
    protected final TimeStampFormat monthYearFormat;
    protected final TimeStampFormat yearFormat;
    protected int pixelsBetweenTicks = 60;
    protected double yearOrderFactor = 6.0;
    protected AxisUnitConverter converter;

    public TimeAxisLabelHandler(Epoch epoch) {
        this(defaultTimeZone, epoch);
    }

    public TimeAxisLabelHandler(TimeZone timeZone, Epoch epoch) {
        this(defaultMinuteSecondFormat, defaultHourDayMonthFormat, defaultHourMinuteFormat, defaultDayMonthYearFormat, defaultDayFormat, defaultMonthFormat, defaultMonthYearFormat, defaultYearFormat, defaultTimeZone, epoch);
    }

    public TimeAxisLabelHandler(TimeStampFormat minuteSecondFormat, TimeStampFormat hourDayMonthFormat, TimeStampFormat hourMinuteFormat, TimeStampFormat dayMonthYearFormat, TimeStampFormat dayFormat, TimeStampFormat monthFormat, TimeStampFormat monthYearFormat, TimeStampFormat yearFormat, TimeZone timeZone, Epoch epoch) {
        this.timeZone = timeZone;
        this.minuteSecondFormat = minuteSecondFormat;
        this.hourDayMonthFormat = hourDayMonthFormat;
        this.hourMinuteFormat = hourMinuteFormat;
        this.dayMonthYearFormat = dayMonthYearFormat;
        this.dayFormat = dayFormat;
        this.monthYearFormat = monthYearFormat;
        this.monthFormat = monthFormat;
        this.yearFormat = yearFormat;
        this.epoch = epoch;
        this.converter = new AxisUnitConverter(){

            @Override
            public double fromAxisUnits(double value) {
                return value;
            }

            @Override
            public double toAxisUnits(double value) {
                return value;
            }
        };
    }

    public TimeStructFactory getHourStructFactory() {
        return hourStructFactory;
    }

    public TimeStructFactory getDayStructFactory() {
        return dayStructFactory;
    }

    public TimeStructFactory getMonthStructFactory() {
        return monthStructFactory;
    }

    public TimeStructFactory getYearStructFactory() {
        return yearStructFactory;
    }

    public TimeStampFormat getYearFormat() {
        return this.yearFormat;
    }

    public TimeStampFormat getMonthYearFormat() {
        return this.monthYearFormat;
    }

    public TimeStampFormat getMonthFormat() {
        return this.monthFormat;
    }

    public TimeStampFormat getDayFormat() {
        return this.dayFormat;
    }

    public TimeStampFormat getDayMonthYearFormat() {
        return this.dayMonthYearFormat;
    }

    public TimeStampFormat getHourMinuteFormat() {
        return this.hourMinuteFormat;
    }

    public TimeStampFormat getHourDayMonthFormat() {
        return this.hourDayMonthFormat;
    }

    public TimeStampFormat getSecondMinuteFormat() {
        return this.minuteSecondFormat;
    }

    public void setPixelsBetweenTicks(int pixels) {
        this.pixelsBetweenTicks = pixels;
    }

    public void setEpoch(Epoch epoch) {
        this.epoch = epoch;
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    public TimeStamp toTimeStamp(double time) {
        return this.epoch.toTimeStamp(time);
    }

    public double fromTimeStamp(TimeStamp time) {
        return this.epoch.fromTimeStamp(time);
    }

    public double tickInterval(List<TimeStamp> list) {
        if (list == null || list.size() < 2) {
            return Time.fromSeconds((double)1.0);
        }
        TimeStamp t1 = list.get(0);
        TimeStamp t2 = list.get(1);
        return t2.durationAfter(t1);
    }

    public static int getYearStep(double spanYears) {
        int order;
        double log10 = Math.log10(spanYears);
        if (log10 - (double)(order = (int)Math.floor(log10)) > 0.999999999999) {
            ++order;
        }
        return (int)Math.max(1.0, Math.pow(10.0, order));
    }

    public static int getRoundedYear(int currentYear, int yearStep) {
        int numSteps = currentYear / yearStep;
        return numSteps * yearStep;
    }

    public List<TimeStamp> tickTimes(Axis1D axis, double axisLengthPixels) {
        TimeStamp t0 = this.toTimeStamp(axis.getMin());
        TimeStamp t1 = this.toTimeStamp(axis.getMax());
        double approxTickInterval_SU = (double)this.pixelsBetweenTicks * t1.durationAfter(t0) / axisLengthPixels;
        if (approxTickInterval_SU > Time.fromDays((double)60.0)) {
            Calendar cal = t0.toCalendar();
            cal.setTimeZone(defaultTimeZone);
            int currentYear = cal.get(1);
            double daysPerYear = 365.25;
            double approxTickInterval_Years = Time.toDays((double)approxTickInterval_SU) / daysPerYear;
            int stepYears = TimeAxisLabelHandler.getYearStep(approxTickInterval_Years * this.yearOrderFactor);
            int startYear = TimeAxisLabelHandler.getRoundedYear(currentYear, stepYears);
            cal.set(1, startYear);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long endTime = t1.toPosixMillis();
            ArrayList<TimeStamp> times = new ArrayList<TimeStamp>();
            while (cal.getTimeInMillis() <= endTime) {
                times.add(TimeStamp.fromCalendar((Calendar)cal));
                cal.add(1, stepYears);
            }
            return times;
        }
        if (approxTickInterval_SU > Time.fromDays((double)10.0)) {
            Calendar cal = t0.toCalendar();
            cal.setTimeZone(defaultTimeZone);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long endTime = t1.toPosixMillis();
            ArrayList<TimeStamp> times = new ArrayList<TimeStamp>();
            while (cal.getTimeInMillis() <= endTime) {
                times.add(TimeStamp.fromCalendar((Calendar)cal));
                cal.add(2, 1);
            }
            return times;
        }
        if (approxTickInterval_SU > Time.fromDays((double)1.0)) {
            int tickInterval_Days = TimeAxisLabelHandler.tickInterval_Days(approxTickInterval_SU);
            Calendar cal = t0.toCalendar();
            cal.setTimeZone(defaultTimeZone);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            long endTime = t1.toPosixMillis() + (long)Time.daysToMilliseconds((double)tickInterval_Days);
            int currentMonth = cal.get(2);
            ArrayList<TimeStamp> times = new ArrayList<TimeStamp>();
            while (cal.getTimeInMillis() <= endTime) {
                int day;
                int max_day;
                int newMonth = cal.get(2);
                if (newMonth != currentMonth) {
                    cal.set(5, 1);
                    currentMonth = newMonth;
                }
                if ((max_day = cal.getActualMaximum(5)) - (day = cal.get(5)) + 1 >= tickInterval_Days / 2) {
                    times.add(TimeStamp.fromCalendar((Calendar)cal));
                }
                cal.add(5, tickInterval_Days);
            }
            return times;
        }
        double tickInterval_SU = TimeAxisLabelHandler.tickInterval_SU(approxTickInterval_SU);
        double zoneOffset_SU = Time.fromMilliseconds((double)this.timeZone.getOffset(t0.toPosixMillis()));
        TimeStamp epoch = TimeStamp.posixEpoch();
        TimeStamp firstTick = epoch.add(tickInterval_SU * Math.floor((t0.durationAfter(epoch) + zoneOffset_SU) / tickInterval_SU) - zoneOffset_SU);
        double numTicks = 1.0 + t1.durationAfter(firstTick) / tickInterval_SU;
        ArrayList<TimeStamp> times = new ArrayList<TimeStamp>();
        int i = 0;
        while ((double)i < numTicks) {
            times.add(firstTick.add((double)i * tickInterval_SU));
            ++i;
        }
        return times;
    }

    public static int tickInterval_Days(double approxTickInterval_SU) {
        int[] rungs_SU;
        double approxTickInterval_Days = Time.secondsToDays((double)approxTickInterval_SU);
        for (int r : rungs_SU = new int[]{2, 3, 4, 5, 8, 10}) {
            if (!(approxTickInterval_Days <= (double)r)) continue;
            return r;
        }
        return 10;
    }

    public static double tickInterval_SU(double approxTickInterval_SU) {
        double[] rungs_SU;
        for (double r : rungs_SU = new double[]{Time.fromSeconds((double)1.0), Time.fromSeconds((double)2.0), Time.fromSeconds((double)5.0), Time.fromSeconds((double)10.0), Time.fromSeconds((double)15.0), Time.fromSeconds((double)20.0), Time.fromSeconds((double)30.0), Time.fromMinutes((double)1.0), Time.fromMinutes((double)2.0), Time.fromMinutes((double)5.0), Time.fromMinutes((double)10.0), Time.fromMinutes((double)15.0), Time.fromMinutes((double)20.0), Time.fromMinutes((double)30.0), Time.fromHours((double)1.0), Time.fromHours((double)2.0), Time.fromHours((double)3.0), Time.fromHours((double)6.0), Time.fromHours((double)12.0), Time.fromDays((double)1.0)}) {
            if (!(approxTickInterval_SU <= r)) continue;
            return r;
        }
        return Time.fromDays((double)1.0);
    }

    public static <T extends Comparable<T>> T min(T a, T b) {
        return a.compareTo(b) < 0 ? a : b;
    }

    public static <T extends Comparable<T>> T max(T a, T b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    public List<TimeStruct> timeStructs(Axis1D axis, List<TimeStamp> tickTimes, TimeStructFactory factory) {
        TimeStamp viewStart = this.toTimeStamp(axis.getMin());
        TimeStamp viewEnd = this.toTimeStamp(axis.getMax());
        ArrayList<TimeStruct> days = new ArrayList<TimeStruct>();
        double maxDayViewDuration = Double.NEGATIVE_INFINITY;
        Calendar calendar = Calendar.getInstance(this.timeZone);
        for (TimeStamp t : tickTimes) {
            TimeStruct day = factory.newTimeStruct();
            days.add(day);
            day.setCalendar(t, calendar);
            day.start = TimeStamp.fromPosixMillis((long)calendar.getTimeInMillis());
            day.incrementCalendar(calendar);
            day.end = TimeStamp.fromPosixMillis((long)calendar.getTimeInMillis());
            day.viewStart = TimeAxisLabelHandler.min(day.end, TimeAxisLabelHandler.max(day.start, viewStart));
            day.viewEnd = TimeAxisLabelHandler.min(day.end, TimeAxisLabelHandler.max(day.start, viewEnd));
            maxDayViewDuration = Math.max(maxDayViewDuration, day.viewEnd.durationAfter(day.viewStart));
        }
        for (TimeStruct day : days) {
            double duration = day.viewEnd.durationAfter(day.viewStart);
            TimeStamp midpoint = day.viewStart.add(0.5 * duration);
            TimeStamp edge = day.viewStart.equals((Object)day.start) ? day.viewEnd : day.viewStart;
            double edginess = 1.0 - Math.max(0.0, Math.min(1.0, duration / maxDayViewDuration));
            day.textCenter = midpoint.add(edginess * edge.durationAfter(midpoint));
        }
        return days;
    }

    @Override
    public double[] getTickPositions(Axis1D axis) {
        List<TimeStamp> tickList = this.tickTimes(axis, axis.getSizePixels());
        double[] tickArray = new double[tickList.size()];
        for (int i = 0; i < tickList.size(); ++i) {
            tickArray[i] = this.fromTimeStamp(tickList.get(i));
        }
        return tickArray;
    }

    @Override
    public String[] getTickLabels(Axis1D axis, double[] tickPositions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] getMinorTickPositions(double[] tickPositions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAxisLabel(Axis1D axis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAxisLabel(String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AxisUnitConverter getAxisUnitConverter() {
        return this.converter;
    }

    @Override
    public void setAxisUnitConverter(AxisUnitConverter converter) {
        this.converter = converter;
    }

    public static class HourStructFactory
    implements TimeStructFactory {
        @Override
        public TimeStruct newTimeStruct() {
            return new HourStruct();
        }
    }

    public static class YearStructFactory
    implements TimeStructFactory {
        @Override
        public TimeStruct newTimeStruct() {
            return new YearStruct();
        }
    }

    public static class MonthStructFactory
    implements TimeStructFactory {
        @Override
        public TimeStruct newTimeStruct() {
            return new MonthStruct();
        }
    }

    public static class DayStructFactory
    implements TimeStructFactory {
        @Override
        public TimeStruct newTimeStruct() {
            return new DayStruct();
        }
    }

    public static interface TimeStructFactory {
        public TimeStruct newTimeStruct();
    }

    public static class HourStruct
    extends TimeStruct {
        @Override
        public void setCalendar(TimeStamp time, Calendar calendar) {
            calendar.setTimeInMillis(time.toPosixMillis());
            calendar.set(12, 0);
            calendar.set(13, 0);
        }

        @Override
        public void incrementCalendar(Calendar calendar) {
            calendar.add(11, 1);
        }
    }

    public static class DayStruct
    extends TimeStruct {
        @Override
        public void setCalendar(TimeStamp time, Calendar calendar) {
            calendar.setTimeInMillis(time.toPosixMillis());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }

        @Override
        public void incrementCalendar(Calendar calendar) {
            calendar.add(5, 1);
        }
    }

    public static class MonthStruct
    extends TimeStruct {
        @Override
        public void setCalendar(TimeStamp time, Calendar calendar) {
            calendar.setTimeInMillis(time.toPosixMillis());
            calendar.set(5, 0);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }

        @Override
        public void incrementCalendar(Calendar calendar) {
            calendar.add(2, 1);
        }
    }

    public static class YearStruct
    extends TimeStruct {
        @Override
        public void setCalendar(TimeStamp time, Calendar calendar) {
            calendar.setTimeInMillis(time.toPosixMillis());
            calendar.set(2, 0);
            calendar.set(5, 0);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        }

        @Override
        public void incrementCalendar(Calendar calendar) {
            calendar.add(1, 1);
        }
    }

    public static abstract class TimeStruct {
        public TimeStamp start;
        public TimeStamp end;
        public TimeStamp viewStart;
        public TimeStamp viewEnd;
        public TimeStamp textCenter;

        public abstract void setCalendar(TimeStamp var1, Calendar var2);

        public abstract void incrementCalendar(Calendar var1);
    }
}

