/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.TimeAxisPainter;
import com.metsci.glimpse.axis.painter.label.TimeAxisLabelHandler;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.metsci.glimpse.util.units.time.format.TimeStampFormat;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.TimeZone;
import javax.media.opengl.GL;

public class TimeYAxisPainter
extends TimeAxisPainter {
    protected static final double dateTextRightPadding = 4.0;

    public TimeYAxisPainter(Epoch epoch) {
        super(new TimeAxisLabelHandler(epoch));
    }

    public TimeYAxisPainter(TimeStampFormat minuteSecondFormat, TimeStampFormat hourMinuteFormat, TimeStampFormat hourDayMonthFormat, TimeStampFormat dayMonthYearFormat, TimeStampFormat dayFormat, TimeStampFormat dayMonthFormat, TimeStampFormat monthYearFormat, TimeStampFormat yearFormat, TimeZone timeZone, Epoch epoch) {
        super(new TimeAxisLabelHandler(minuteSecondFormat, hourMinuteFormat, hourDayMonthFormat, dayMonthYearFormat, dayFormat, dayMonthFormat, monthYearFormat, yearFormat, timeZone, epoch));
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        super.paintTo(context, bounds, axis);
        if (this.textRenderer == null) {
            return;
        }
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glColor4fv(this.tickColor, 0);
        List<TimeStamp> tickTimes = this.handler.tickTimes(axis, height);
        double tickInterval = this.handler.tickInterval(tickTimes);
        gl.glBegin(1);
        for (TimeStamp t : tickTimes) {
            double y = axis.valueToScreenPixel(this.fromTimeStamp(t));
            gl.glVertex2d((double)width, y);
            gl.glVertex2d((double)(width - this.tickLineLength), y);
        }
        gl.glEnd();
        GlimpseColor.setColor(this.textRenderer, this.textColor);
        if (tickInterval <= Time.fromMinutes((double)1.0)) {
            double jTimeText = this.printTickLabels(tickTimes, axis, this.handler.getSecondMinuteFormat(), width, height);
            this.printHoverLabels(gl, tickTimes, axis, this.handler.getHourDayMonthFormat(), this.handler.getHourStructFactory(), jTimeText, width, height);
        } else if (tickInterval <= Time.fromHours((double)12.0)) {
            double jTimeText = this.printTickLabels(tickTimes, axis, this.handler.getHourMinuteFormat(), width, height);
            this.printHoverLabels(gl, tickTimes, axis, this.handler.getDayMonthYearFormat(), this.handler.getDayStructFactory(), jTimeText, width, height);
        } else if (tickInterval <= Time.fromDays((double)10.0)) {
            double jTimeText = this.printTickLabels(tickTimes, axis, this.handler.getDayFormat(), width, height);
            this.printHoverLabels(gl, tickTimes, axis, this.handler.getMonthYearFormat(), this.handler.getMonthStructFactory(), jTimeText, width, height);
        } else if (tickInterval <= Time.fromDays((double)60.0)) {
            double jTimeText = this.printTickLabels(tickTimes, axis, this.handler.getMonthFormat(), width, height);
            this.printHoverLabels(gl, tickTimes, axis, this.handler.getYearFormat(), this.handler.getYearStructFactory(), jTimeText, width, height);
        } else {
            this.printTickLabels(tickTimes, axis, this.handler.getYearFormat(), width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printHoverLabels(GL gl, List<TimeStamp> tickTimes, Axis1D axis, TimeStampFormat format, TimeAxisLabelHandler.TimeStructFactory factory, double iTimeText, int width, int height) {
        List<TimeAxisLabelHandler.TimeStruct> days = this.handler.timeStructs(axis, tickTimes, factory);
        for (TimeAxisLabelHandler.TimeStruct day : days) {
            int jApprox;
            int jMax;
            String text = day.textCenter.toString(format);
            Rectangle2D textBounds = this.textRenderer.getBounds(text);
            double halfTextHeight = 0.5 * textBounds.getWidth();
            int jMin = (int)Math.ceil((double)axis.valueToScreenPixel(this.fromTimeStamp(day.start)) + halfTextHeight);
            int j = Math.max(jMin, Math.min(jMax = (int)Math.floor((double)axis.valueToScreenPixel(this.fromTimeStamp(day.end)) - halfTextHeight), jApprox = axis.valueToScreenPixel(this.fromTimeStamp(day.textCenter))));
            if ((double)j - halfTextHeight < 0.0 || (double)j + halfTextHeight > (double)height) continue;
            int i = (int)Math.floor(iTimeText - 4.0 - 1.0);
            this.textRenderer.beginRendering(width, height);
            gl.glMatrixMode(5888);
            gl.glPushMatrix();
            try {
                gl.glTranslatef((float)i, (float)j, 0.0f);
                gl.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
                this.textRenderer.draw(text, (int)Math.round(-halfTextHeight), 0);
            }
            finally {
                this.textRenderer.endRendering();
                gl.glPopMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double printTickLabels(List<TimeStamp> tickTimes, Axis1D axis, TimeStampFormat format, int width, int height) {
        int iTimeText = Integer.MAX_VALUE;
        this.textRenderer.beginRendering(width, height);
        try {
            for (TimeStamp t : tickTimes) {
                String string = t.toString(format);
                Rectangle2D textBounds = this.textRenderer.getBounds(string);
                double textHeight = textBounds.getHeight();
                int j = (int)Math.round((double)axis.valueToScreenPixel(this.fromTimeStamp(t)) - 0.5 * Math.max(1.0, textHeight - 2.0));
                if (j < 0 || (double)j + textHeight > (double)height) continue;
                int i = (int)Math.round((double)(width - this.tickLineLength) - textBounds.getWidth()) - 1;
                iTimeText = Math.min(iTimeText, i);
                this.textRenderer.draw(string, i, j);
            }
        }
        finally {
            this.textRenderer.endRendering();
        }
        return iTimeText;
    }
}

