/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.label.TimeAxisLabelHandler;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter1D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import javax.media.opengl.GLContext;

public abstract class TimeAxisPainter
extends GlimpsePainter1D {
    protected float[] tickColor;
    protected float[] textColor;
    protected TimeAxisLabelHandler handler;
    protected TextRenderer textRenderer;
    protected volatile Font newFont = null;
    protected volatile boolean antialias = false;
    protected boolean showCurrentTimeLabel = false;
    protected float[] currentTimeTextColor;
    protected float[] currentTimeTickColor;
    protected float currentTimeLineThickness;
    protected int hoverLabelOffset = 4;
    protected int tickLineLength = 4;
    protected boolean fontSet = false;
    protected boolean tickColorSet = false;
    protected boolean labelColorSet = false;

    public TimeAxisPainter(TimeAxisLabelHandler handler) {
        this.handler = handler;
        this.newFont = FontUtils.getBitstreamVeraSansPlain(12.0f);
        this.tickColor = GlimpseColor.getBlack();
        this.textColor = GlimpseColor.getBlack();
        this.setCurrentTimeTextColor(GlimpseColor.getGreen(0.5f));
        this.setCurrentTimeTickColor(GlimpseColor.getGreen(1.0f));
        this.currentTimeLineThickness = 3.0f;
    }

    public TimeAxisLabelHandler getLabelHandler() {
        return this.handler;
    }

    public void setTickLineLength(int pixels) {
        this.tickLineLength = pixels;
    }

    public void setPixelsBetweenTicks(int pixels) {
        this.handler.setPixelsBetweenTicks(pixels);
    }

    public void setEpoch(Epoch epoch) {
        this.handler.setEpoch(epoch);
    }

    public Epoch getEpoch() {
        return this.handler.getEpoch();
    }

    public TimeStamp toTimeStamp(double time) {
        return this.handler.toTimeStamp(time);
    }

    public double fromTimeStamp(TimeStamp time) {
        return this.handler.fromTimeStamp(time);
    }

    public void setCurrentTimeTickColor(float[] color) {
        this.currentTimeTickColor = color;
    }

    public void setCurrentTimeTextColor(float[] color) {
        this.currentTimeTextColor = color;
    }

    public void showCurrentTimeLabel(boolean show) {
        this.showCurrentTimeLabel = show;
    }

    public void setFont(Font font) {
        this.setFont(font, true);
    }

    public void setTickColor(float[] color) {
        this.tickColor = color;
        this.tickColorSet = true;
    }

    public void setTextColor(float[] color) {
        this.textColor = color;
        this.labelColorSet = true;
    }

    public void setFont(Font font, boolean antialias) {
        this.newFont = font;
        this.antialias = antialias;
        this.fontSet = true;
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        if (laf == null) {
            return;
        }
        if (!this.fontSet) {
            this.setFont(laf.getFont(AbstractLookAndFeel.AXIS_FONT), false);
            this.fontSet = false;
        }
        if (!this.labelColorSet) {
            this.setTextColor(laf.getColor(AbstractLookAndFeel.AXIS_TEXT_COLOR));
            this.labelColorSet = false;
        }
        if (!this.tickColorSet) {
            this.setTickColor(laf.getColor(AbstractLookAndFeel.AXIS_TICK_COLOR));
            this.tickColorSet = false;
        }
    }

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        if (this.newFont != null) {
            if (this.textRenderer != null) {
                this.textRenderer.dispose();
            }
            this.textRenderer = new TextRenderer(this.newFont, this.antialias, false);
            this.newFont = null;
        }
    }
}

