/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverters;
import com.metsci.glimpse.axis.painter.label.GridAxisExponentLabelHandler;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class NumericXYAxisPainter
extends GlimpsePainter2D {
    protected TextRenderer textRenderer;
    protected Font font;
    protected volatile Font newFont = null;
    protected volatile boolean antialias = false;
    protected float[] lineColor;
    protected float[] textColor;
    protected int tickWidth = 5;
    protected int labelBuffer = 4;
    protected int rightBuffer = 60;
    protected int topBuffer = 60;
    protected AxisLabelHandler ticksX;
    protected AxisLabelHandler ticksY;
    protected boolean showHorizontal = true;
    protected boolean showVertical = true;
    protected boolean showLabelsNearOrigin = false;
    protected boolean showOrigin = true;
    protected boolean showZero = false;
    protected boolean lockLeft = false;
    protected boolean lockRight = false;
    protected boolean lockTop = false;
    protected boolean lockBottom = false;
    protected boolean fontSet = false;
    protected boolean tickColorSet = false;
    protected boolean labelColorSet = false;

    public NumericXYAxisPainter(AxisLabelHandler ticksX, AxisLabelHandler ticksY) {
        this.ticksX = ticksX;
        this.ticksY = ticksY;
        this.setFont(FontUtils.getDefaultPlain(12.0f), false);
        this.textColor = GlimpseColor.getBlack();
        this.lineColor = GlimpseColor.getBlack();
    }

    public NumericXYAxisPainter() {
        this(new GridAxisExponentLabelHandler(), new GridAxisExponentLabelHandler());
    }

    public void setFont(Font font) {
        this.setFont(font, true);
    }

    public NumericXYAxisPainter setFont(Font font, boolean antialias) {
        this.newFont = font;
        this.antialias = antialias;
        this.fontSet = true;
        return this;
    }

    public NumericXYAxisPainter setTextColor(float[] rgba) {
        this.textColor = rgba;
        this.labelColorSet = true;
        return this;
    }

    public NumericXYAxisPainter setLineColor(float r, float g, float b, float a) {
        this.lineColor[0] = r;
        this.lineColor[1] = g;
        this.lineColor[2] = b;
        this.lineColor[3] = a;
        return this;
    }

    public NumericXYAxisPainter setLockLeft(boolean lock) {
        this.lockLeft = lock;
        return this;
    }

    public NumericXYAxisPainter setLockRight(boolean lock) {
        this.lockRight = lock;
        return this;
    }

    public NumericXYAxisPainter setLockBottom(boolean lock) {
        this.lockBottom = lock;
        return this;
    }

    public NumericXYAxisPainter setLockTop(boolean lock) {
        this.lockTop = lock;
        return this;
    }

    public NumericXYAxisPainter setShowOriginLabel(boolean show) {
        this.showZero = show;
        return this;
    }

    public NumericXYAxisPainter setLineColor(float[] rgba) {
        this.lineColor = rgba;
        this.tickColorSet = true;
        return this;
    }

    public NumericXYAxisPainter setShowVerticalTicks(boolean show) {
        this.showVertical = show;
        return this;
    }

    public NumericXYAxisPainter setShowHorizontalTicks(boolean show) {
        this.showHorizontal = show;
        return this;
    }

    public NumericXYAxisPainter setShowLabelsNearOrigin(boolean show) {
        this.showLabelsNearOrigin = show;
        return this;
    }

    public NumericXYAxisPainter setShowOriginLines(boolean show) {
        this.showOrigin = show;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        double doriginY;
        int originX;
        if (this.newFont != null) {
            if (this.textRenderer != null) {
                this.textRenderer.dispose();
            }
            this.textRenderer = new TextRenderer(this.newFont, this.antialias, false);
            this.newFont = null;
        }
        if (this.textRenderer == null) {
            return;
        }
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        double[] positionsX = this.ticksX.getTickPositions(axis.getAxisX());
        double[] positionsY = this.ticksY.getTickPositions(axis.getAxisY());
        AxisUnitConverter convX = this.ticksX.getAxisUnitConverter();
        convX = convX == null ? AxisUnitConverters.identity : convX;
        AxisUnitConverter convY = this.ticksY.getAxisUnitConverter();
        convY = convY == null ? AxisUnitConverters.identity : convY;
        double onePixelX = 0.5 / axisX.getPixelsPerValue();
        double onePixelY = 0.5 / axisY.getPixelsPerValue();
        int originY = axisY.valueToScreenPixel(0.0);
        if (originY < 0 || this.lockBottom) {
            originY = 0;
        }
        if (originY > height || this.lockTop) {
            originY = height;
        }
        if ((originX = axisX.valueToScreenPixel(0.0)) < 0 || this.lockLeft) {
            originX = 0;
        }
        if (originX > width || this.lockRight) {
            originX = width;
        }
        boolean rightCornerX = false;
        boolean leftCornerX = false;
        boolean topCornerY = false;
        boolean bottomCornerY = false;
        double doriginX = 0.0;
        if (doriginX <= axisX.getMin() || this.lockLeft) {
            doriginX = axisX.getMin() + onePixelX;
            leftCornerX = true;
        }
        if (doriginX > axisX.getMax() || this.lockRight) {
            doriginX = axisX.getMax();
            rightCornerX = true;
        }
        if ((doriginY = 0.0) <= axisY.getMin() || this.lockBottom) {
            doriginY = axisY.getMin() + onePixelY;
            topCornerY = true;
        }
        if (doriginY > axisY.getMax() || this.lockTop) {
            doriginY = axisY.getMax();
            bottomCornerY = true;
        }
        boolean labelRight = width - originX > this.rightBuffer;
        boolean labelTop = height - originY > this.topBuffer;
        boolean[] paintLabelsX = new boolean[positionsX.length];
        boolean[] paintLabelsY = new boolean[positionsY.length];
        GlimpseColor.setColor(this.textRenderer, this.textColor);
        this.textRenderer.beginRendering(width, height);
        try {
            if (this.showHorizontal) {
                int offsetY;
                String[] labelsX = this.ticksX.getTickLabels(axis.getAxisX(), positionsX);
                if (labelTop) {
                    offsetY = this.tickWidth + this.labelBuffer;
                } else {
                    Rectangle2D textBounds = this.textRenderer.getBounds(labelsX[0]);
                    offsetY = (int)(-(textBounds.getHeight() + (double)this.tickWidth + (double)this.labelBuffer));
                }
                for (int i = 0; i < positionsX.length; ++i) {
                    String label = labelsX[i];
                    double valueX = positionsX[i];
                    if (valueX == 0.0 && !this.showZero) continue;
                    int posX = axisX.valueToScreenPixel(valueX);
                    paintLabelsX[i] = this.shouldPaintLabel(rightCornerX, leftCornerX, posX, width, this.rightBuffer);
                    if (!paintLabelsX[i]) continue;
                    this.textRenderer.draw(label, posX + this.labelBuffer, originY + offsetY);
                }
            }
            if (this.showVertical) {
                String[] labelsY = this.ticksY.getTickLabels(axis.getAxisY(), positionsY);
                for (int i = 0; i < positionsY.length; ++i) {
                    String label = labelsY[i];
                    Rectangle2D textBounds = this.textRenderer.getBounds(label);
                    double valueY = positionsY[i];
                    if (valueY == 0.0 && !this.showZero) continue;
                    int offsetX = labelRight ? this.tickWidth + this.labelBuffer : (int)(-(textBounds.getWidth() + (double)this.tickWidth + (double)this.labelBuffer));
                    int posY = axisY.valueToScreenPixel(valueY);
                    paintLabelsY[i] = this.shouldPaintLabel(bottomCornerY, topCornerY, posY, height, this.topBuffer);
                    if (!paintLabelsY[i]) continue;
                    this.textRenderer.draw(label, originX + offsetX, posY + this.labelBuffer);
                }
            }
        }
        finally {
            this.textRenderer.endRendering();
        }
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(axis.getMinX(), axis.getMaxX(), axis.getMinY(), axis.getMaxY(), -1.0, 1.0);
        GlimpseColor.glColor(gl, this.lineColor);
        double labelBufferX = (double)this.labelBuffer / axisX.getPixelsPerValue();
        double labelBufferY = (double)this.labelBuffer / axisY.getPixelsPerValue();
        gl.glBegin(1);
        try {
            int i;
            if (this.showHorizontal) {
                double tickWidthY = (double)this.tickWidth / axisY.getPixelsPerValue();
                for (i = 0; i < positionsX.length; ++i) {
                    if (!paintLabelsX[i]) continue;
                    double valueX = convX.fromAxisUnits(positionsX[i]);
                    gl.glVertex2d(valueX, doriginY - tickWidthY);
                    gl.glVertex2d(valueX, doriginY + tickWidthY);
                    if (labelTop) {
                        gl.glVertex2d(valueX, doriginY + tickWidthY);
                        gl.glVertex2d(valueX + labelBufferX, doriginY + tickWidthY + labelBufferY);
                        continue;
                    }
                    gl.glVertex2d(valueX, doriginY - tickWidthY);
                    gl.glVertex2d(valueX + labelBufferX, doriginY - tickWidthY - labelBufferY);
                }
            }
            if (this.showVertical) {
                double tickWidthX = (double)this.tickWidth / axisX.getPixelsPerValue();
                for (i = 0; i < positionsY.length; ++i) {
                    if (!paintLabelsY[i]) continue;
                    double valueY = convY.fromAxisUnits(positionsY[i]);
                    gl.glVertex2d(doriginX - tickWidthX, valueY);
                    gl.glVertex2d(doriginX + tickWidthX, valueY);
                    if (labelRight) {
                        gl.glVertex2d(doriginX + tickWidthX, valueY);
                        gl.glVertex2d(doriginX + tickWidthX + labelBufferX, valueY + labelBufferY);
                        continue;
                    }
                    gl.glVertex2d(doriginX - tickWidthX, valueY);
                    gl.glVertex2d(doriginX - tickWidthX - labelBufferX, valueY + labelBufferY);
                }
            }
            if (this.showHorizontal && this.showOrigin) {
                gl.glVertex2d(convX.fromAxisUnits(axis.getMinX()), convY.fromAxisUnits(doriginY));
                gl.glVertex2d(convX.fromAxisUnits(axis.getMaxX()), convY.fromAxisUnits(doriginY));
            }
            if (this.showVertical && this.showOrigin) {
                gl.glVertex2d(convX.fromAxisUnits(doriginX), convY.fromAxisUnits(axis.getMinY()));
                gl.glVertex2d(convX.fromAxisUnits(doriginX), convY.fromAxisUnits(axis.getMaxY()));
            }
        }
        finally {
            gl.glEnd();
        }
    }

    protected boolean shouldPaintLabel(boolean atMinCorner, boolean atMaxCorner, int labelPos, int axisSize, int buffer) {
        return this.showLabelsNearOrigin || (!atMaxCorner || labelPos > buffer) && (!atMinCorner || labelPos < axisSize - buffer);
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        if (!this.fontSet) {
            this.setFont(laf.getFont(AbstractLookAndFeel.AXIS_FONT), false);
            this.fontSet = false;
        }
        if (!this.tickColorSet) {
            this.setLineColor(laf.getColor(AbstractLookAndFeel.AXIS_TICK_COLOR));
            this.tickColorSet = false;
        }
        if (!this.labelColorSet) {
            this.setTextColor(laf.getColor(AbstractLookAndFeel.AXIS_TEXT_COLOR));
            this.labelColorSet = false;
        }
    }

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }
}

