/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.NumericAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.support.color.GlimpseColor;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;

public class NumericXAxisPainter
extends NumericAxisPainter {
    protected boolean packLabel = false;

    public NumericXAxisPainter(AxisLabelHandler ticks) {
        super(ticks);
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        this.updateTextRenderer();
        if (this.textRenderer == null) {
            return;
        }
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
        this.paintTicks(gl, axis, width, height);
        this.paintSelectionLine(gl, axis, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTicks(GL gl, Axis1D axis, int width, int height) {
        int i;
        double[] xTicks = this.ticks.getTickPositions(axis);
        String[] xLabels = this.ticks.getTickLabels(axis, xTicks);
        AxisUnitConverter converter = this.ticks.getAxisUnitConverter();
        int min = -1;
        int max = xTicks.length;
        int jTick0 = this.getTickTopY(height, this.tickSize);
        int jTick1 = this.getTickBottomY(height, this.tickSize);
        GlimpseColor.glColor(gl, this.tickColor);
        gl.glBegin(1);
        try {
            for (i = 0; i < xTicks.length; ++i) {
                int iTick = axis.valueToScreenPixel(converter.fromAxisUnits(xTicks[i]));
                if (iTick == width) {
                    --iTick;
                }
                if (iTick < 0 && !this.showLabelsForOffscreenTicks) {
                    min = i;
                    continue;
                }
                if (iTick > width && !this.showLabelsForOffscreenTicks) {
                    max = i;
                    break;
                }
                gl.glVertex2f((float)iTick, (float)jTick0);
                gl.glVertex2f((float)iTick, (float)jTick1);
            }
            if (this.showMinorTicks) {
                double[] xMinor = this.ticks.getMinorTickPositions(xTicks);
                jTick0 = this.getTickTopY(height, this.tickSize / 2);
                jTick1 = this.getTickBottomY(height, this.tickSize / 2);
                for (int i2 = 0; i2 < xMinor.length; ++i2) {
                    int iTick = axis.valueToScreenPixel(converter.fromAxisUnits(xMinor[i2]));
                    gl.glVertex2f((float)iTick, (float)jTick0);
                    gl.glVertex2f((float)iTick, (float)jTick1);
                }
            }
        }
        finally {
            gl.glEnd();
        }
        GlimpseColor.setColor(this.textRenderer, this.tickLabelColor);
        this.textRenderer.beginRendering(width, height);
        try {
            for (i = min + 1; i < max; ++i) {
                double xTick = xTicks[i];
                String xLabel = xLabels[i];
                Rectangle2D tickTextBounds = this.textRenderer.getBounds(xLabel);
                Rectangle2D dashTextBounds = this.textRenderer.getBounds("-");
                double dashTextWidth = xTick < 0.0 ? dashTextBounds.getWidth() : 0.0;
                double absTextWidth = tickTextBounds.getWidth() - dashTextWidth;
                int jTickText = this.getTickTextPositionY(height, (int)tickTextBounds.getHeight());
                int iTickText = (int)Math.round((double)axis.valueToScreenPixel(converter.fromAxisUnits(xTick)) - 0.5 * absTextWidth - dashTextWidth);
                if (this.keepLabelsForExtremaFullyVisible) {
                    if (iTickText < 0) {
                        iTickText = 0;
                    }
                    if ((double)iTickText + tickTextBounds.getWidth() > (double)width) {
                        iTickText = width - (int)tickTextBounds.getWidth();
                    }
                }
                this.textRenderer.draw(xLabel, iTickText, jTickText);
            }
            if (this.showLabel) {
                String label = this.ticks.getAxisLabel(axis);
                Rectangle2D axisLabelBounds = this.textRenderer.getBounds(label);
                int iAxisLabel = Math.round(0.5f * (float)(width - (int)axisLabelBounds.getWidth()));
                int jAxisLabel = this.getAxisLabelPositionY(height, (int)axisLabelBounds.getHeight());
                GlimpseColor.setColor(this.textRenderer, this.axisLabelColor);
                this.textRenderer.draw(label, iAxisLabel, jAxisLabel);
            }
        }
        finally {
            this.textRenderer.endRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintSelectionLine(GL gl, Axis1D axis, int width, int height) {
        if (this.showSelectionLine) {
            gl.glLineWidth((float)this.markerWidth);
            int x0 = axis.valueToScreenPixel(axis.getSelectionCenter());
            gl.glBegin(1);
            try {
                gl.glVertex2f((float)x0, 0.0f);
                gl.glVertex2f((float)x0, (float)height);
            }
            finally {
                gl.glEnd();
            }
        }
    }

    public int getAxisLabelPositionY(int height, int textHeight) {
        return this.labelBufferSize;
    }

    public int getTickTextPositionY(int height, int textHeight) {
        return height - 1 - this.tickBufferSize - this.tickSize - this.textBufferSize - textHeight;
    }

    public int getTickTopY(int height, int size) {
        return height - 1 - this.tickBufferSize;
    }

    public int getTickBottomY(int height, int size) {
        return height - 1 - this.tickBufferSize - size;
    }
}

