/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.painter;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.painter.NumericYAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import javax.media.opengl.GL;

public class ColorYAxisPainter
extends NumericYAxisPainter {
    protected ColorTexture1D colorTexture;
    protected int colorBarSize = 10;
    protected boolean outline = true;

    public ColorYAxisPainter(AxisLabelHandler ticks) {
        super(ticks);
        this.setTickSize(this.colorBarSize + 0);
    }

    public void setEnableOutline(boolean doOutline) {
        this.outline = doOutline;
    }

    public void setColorScale(ColorTexture1D colorTexture) {
        this.colorTexture = colorTexture;
    }

    public void setColorBarSize(int size) {
        this.colorBarSize = size;
        this.setTickSize(this.colorBarSize + 2);
    }

    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis1D axis) {
        this.updateTextRenderer();
        if (this.textRenderer == null) {
            return;
        }
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-0.5, (double)((float)(width - 1) + 0.5f), -0.5, (double)((float)(height - 1) + 0.5f), -1.0, 1.0);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        this.paintColorScale(gl, axis, width, height);
        this.paintTicks(gl, axis, width, height);
        this.paintAxisLabel(gl, axis, width, height);
        this.paintSelectionLine(gl, axis, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintColorScale(GL gl, Axis1D axis, int width, int height) {
        if (this.colorTexture != null) {
            this.colorTexture.prepare(gl, 0);
            int x1 = this.getColorBarMinX(width);
            int x2 = this.getColorBarMaxX(width);
            gl.glTexEnvf(8960, 8704, 7681.0f);
            gl.glPolygonMode(1028, 6914);
            gl.glEnable(3552);
            gl.glBegin(7);
            try {
                gl.glTexCoord1f(0.0f);
                gl.glVertex2f((float)x2, 0.0f);
                gl.glTexCoord1f(0.0f);
                gl.glVertex2f((float)x1, 0.0f);
                gl.glTexCoord1f(1.0f);
                gl.glVertex2f((float)x1, (float)(height - 1));
                gl.glTexCoord1f(1.0f);
                gl.glVertex2f((float)x2, (float)(height - 1));
            }
            finally {
                gl.glEnd();
            }
            gl.glDisable(3552);
        }
        if (this.outline) {
            this.outlineColorQuad(gl, axis, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outlineColorQuad(GL gl, Axis1D axis, int width, int height) {
        float x1 = this.getColorBarMinX(width);
        float x2 = this.getColorBarMaxX(width);
        gl.glColor4fv(this.tickColor, 0);
        gl.glBegin(1);
        try {
            gl.glVertex2f(x2, 0.0f);
            gl.glVertex2f(x1, 0.0f);
            gl.glVertex2f(x1, 0.0f);
            gl.glVertex2f(x1, (float)(height - 1));
            gl.glVertex2f(x1, (float)(height - 1));
            gl.glVertex2f(x2, (float)(height - 1));
            gl.glVertex2f(x2, (float)(height - 1));
            gl.glVertex2f(x2, 0.0f);
        }
        finally {
            gl.glEnd();
        }
    }

    public int getColorBarMinX(int width) {
        return width - 1 - this.tickBufferSize - this.colorBarSize;
    }

    public int getColorBarMaxX(int width) {
        return width - 1 - this.tickBufferSize;
    }
}

