/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.axis.factory;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.factory.AxisFactory1D;
import com.metsci.glimpse.axis.factory.AxisFactory2D;
import com.metsci.glimpse.axis.factory.FixedAxisFactory1D;
import com.metsci.glimpse.context.GlimpseTargetStack;

public class FixedAxisFactory2D
implements AxisFactory2D {
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;

    public FixedAxisFactory2D(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public Axis2D newAxis(GlimpseTargetStack stack, Axis2D axis) {
        Axis2D newAxis = axis.clone();
        newAxis.setParent(null);
        newAxis.getAxisX().setMin(this.minX);
        newAxis.getAxisX().setMax(this.maxX);
        newAxis.getAxisY().setMin(this.minY);
        newAxis.getAxisY().setMax(this.maxY);
        newAxis.getAxisX().lockMin(this.minX);
        newAxis.getAxisX().lockMax(this.maxX);
        newAxis.getAxisY().lockMin(this.minY);
        newAxis.getAxisY().lockMax(this.maxY);
        return newAxis;
    }

    @Override
    public AxisFactory1D getAxisFactoryX(GlimpseTargetStack stack) {
        return new FixedAxisFactory1D(this.minX, this.maxX);
    }

    @Override
    public AxisFactory1D getAxisFactoryY(GlimpseTargetStack stack) {
        return new FixedAxisFactory1D(this.minY, this.maxY);
    }
}

