/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.stacked;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.stacked.HorizontalTimelinePlotExample;
import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.plot.stacked.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import com.metsci.glimpse.plot.timeline.animate.DragManager;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfo;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.support.settings.OceanLookAndFeel;
import com.metsci.glimpse.util.units.time.TimeStamp;

public class VerticalTimelinePlotExample
extends HorizontalTimelinePlotExample {
    public static void main(String[] args) throws Exception {
        Example example = Example.showWithSwing(new VerticalTimelinePlotExample());
        example.getCanvas().setLookAndFeel((LookAndFeel)new OceanLookAndFeel());
        DragManager.attach((StackedTimePlot2D)((StackedTimePlot2D)example.getLayout()), (RepaintManager)example.getManager());
    }

    @Override
    public StackedTimePlot2D getLayout() {
        StackedTimePlot2D plot = super.getLayout();
        plot.setPlotSpacing(20);
        for (TimePlotInfo info : plot.getAllTimePlots()) {
            info.getLabelPainter().setHorizontalLabels(true);
        }
        return plot;
    }

    @Override
    protected StackedTimePlot2D createPlot() {
        return new StackedTimePlot2D(StackedPlot2D.Orientation.HORIZONTAL, Epoch.currentTime());
    }

    @Override
    protected void addData(TrackPainter painter, Epoch epoch, double data, TimeStamp time) {
        painter.addPoint(1, 0, data, epoch.fromTimeStamp(time), time.toPosixMillis());
    }

    @Override
    protected void setBounds(TimePlotInfo chart) {
        Axis1D axis = chart.getLayout().getAxis().getAxisX();
        axis.setMin(-20.0);
        axis.setMax(20.0);
    }

    @Override
    protected void addMouseListener(final Epoch epoch, final TimePlotInfo plot1) {
        plot1.getLayout().addGlimpseMouseListener(new GlimpseMouseListener(){

            public void mouseEntered(GlimpseMouseEvent event) {
            }

            public void mouseExited(GlimpseMouseEvent event) {
            }

            public void mousePressed(GlimpseMouseEvent event) {
                int pixelX = event.getX();
                int pixelY = event.getY();
                Axis1D axisTime = event.getAxis2D().getAxisY();
                TaggedAxis1D axisTaggedTime = plot1.getCommonAxis(event.getTargetStack());
                StackedTimePlot2D parent = plot1.getStackedTimePlot();
                Tag timeSelectionMin = parent.getTimeSelectionMinTag();
                Tag timeSelectionMax = parent.getTimeSelectionMaxTag();
                Tag timeSelectionAlternateMin = axisTaggedTime.getTag("min_time");
                Tag timeSelectionAlternateMax = axisTaggedTime.getTag("max_time");
                TimeStamp timeSelectionMinTime = epoch.toTimeStamp(timeSelectionMin.getValue());
                TimeStamp timeSelectionMaxTime = epoch.toTimeStamp(timeSelectionMax.getValue());
                Axis1D axisX = event.getAxis2D().getAxisX();
                double axisValueY = axisTime.screenPixelToValue((double)pixelY);
                TimeStamp axisValueTime = epoch.toTimeStamp(axisValueY);
                double axisValueX = axisX.screenPixelToValue((double)(axisX.getSizePixels() - pixelX));
                System.out.printf("PixelX: %d PixelY: %d ValueX: %f ValueY: %f Time: %s Selection Min: %s Selection Max: %s %n", pixelX, pixelY, axisValueX, axisValueY, axisValueTime, timeSelectionMinTime, timeSelectionMaxTime);
            }

            public void mouseReleased(GlimpseMouseEvent event) {
            }
        });
    }
}

