/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.stacked;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.plot.stacked.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import com.metsci.glimpse.plot.timeline.animate.DragManager;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfo;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.support.settings.OceanLookAndFeel;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;

public class HorizontalTimelinePlotExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example example = Example.showWithSwing(new HorizontalTimelinePlotExample());
        example.getCanvas().setLookAndFeel((LookAndFeel)new OceanLookAndFeel());
        DragManager.attach((StackedTimePlot2D)((StackedTimePlot2D)example.getLayout()), (RepaintManager)example.getManager());
    }

    public StackedTimePlot2D getLayout() {
        StackedTimePlot2D plot = this.createPlot();
        Epoch epoch = plot.getEpoch();
        TimeStamp selectionMaxTime = epoch.getTimeStamp();
        TimeStamp selectionMinTime = selectionMaxTime.subtract(Time.fromHours((double)3.0));
        TimeStamp axisMaxTime = selectionMaxTime.add(Time.fromHours((double)1.0));
        TimeStamp axisMinTime = selectionMaxTime.subtract(Time.fromHours((double)20.0));
        plot.setTimeSelection(selectionMinTime, selectionMaxTime);
        plot.setTimeAxisBounds(axisMinTime, axisMaxTime);
        plot.setPlotSpacing(2);
        plot.setBorderSize(4);
        TimePlotInfo plot1 = plot.createTimePlot((Object)"speed-plot-1-id");
        TimePlotInfo plot2 = plot.createTimePlot((Object)"viscosity-plot-2-id");
        plot1.setLabelText("Snail Speed (furlongs per fornight)");
        plot2.setLabelText("Snail Slime Viscosity (pascal-seconds)");
        plot.setLabelSize(30);
        plot.showLabels(true);
        plot1.getLabelPainter().setHorizontalLabels(false);
        plot2.getLabelPainter().setHorizontalLabels(false);
        this.setChartData(plot1, epoch, axisMinTime, axisMaxTime);
        this.setChartData(plot2, epoch, axisMinTime, axisMaxTime);
        this.addMouseListener(epoch, plot1);
        this.addMouseListener(epoch, plot2);
        return plot;
    }

    protected void addMouseListener(final Epoch epoch, final TimePlotInfo plot1) {
        plot1.getLayout().addGlimpseMouseListener(new GlimpseMouseListener(){

            public void mouseEntered(GlimpseMouseEvent event) {
            }

            public void mouseExited(GlimpseMouseEvent event) {
            }

            public void mousePressed(GlimpseMouseEvent event) {
                int pixelX = event.getX();
                int pixelY = event.getY();
                Axis1D axisTime = event.getAxis2D().getAxisX();
                TaggedAxis1D axisTaggedTime = plot1.getCommonAxis(event.getTargetStack());
                StackedTimePlot2D parent = plot1.getStackedTimePlot();
                Tag timeSelectionMin = parent.getTimeSelectionMinTag();
                Tag timeSelectionMax = parent.getTimeSelectionMaxTag();
                Tag timeSelectionAlternateMin = axisTaggedTime.getTag("min_time");
                Tag timeSelectionAlternateMax = axisTaggedTime.getTag("max_time");
                TimeStamp timeSelectionMinTime = epoch.toTimeStamp(timeSelectionMin.getValue());
                TimeStamp timeSelectionMaxTime = epoch.toTimeStamp(timeSelectionMax.getValue());
                Axis1D axisY = event.getAxis2D().getAxisY();
                double axisValueX = axisTime.screenPixelToValue((double)pixelX);
                TimeStamp axisValueTime = epoch.toTimeStamp(axisValueX);
                double axisValueY = axisY.screenPixelToValue((double)(axisY.getSizePixels() - pixelY));
                System.out.printf("PixelX: %d PixelY: %d ValueX: %f ValueY: %f Time: %s Selection Min: %s Selection Max: %s %n", pixelX, pixelY, axisValueX, axisValueY, axisValueTime, timeSelectionMinTime, timeSelectionMaxTime);
            }

            public void mouseReleased(GlimpseMouseEvent event) {
            }
        });
    }

    protected void setChartData(TimePlotInfo chart, Epoch epoch, TimeStamp startTime, TimeStamp endTime) {
        TrackPainter painter = new TrackPainter();
        painter.setPointColor(1, GlimpseColor.getGreen());
        painter.setPointSize(1, 5.0f);
        painter.setShowLines(1, false);
        double end = endTime.toPosixSeconds();
        double time = startTime.toPosixSeconds();
        double step = (end - time) / 200.0;
        float valueX = 0.0f;
        while (time < end) {
            this.addData(painter, epoch, valueX += (float)(Math.random() * 2.0 - 1.0), TimeStamp.fromPosixSeconds((double)(time += step)));
        }
        chart.addPainter((GlimpsePainter)painter);
        this.setBounds(chart);
    }

    protected StackedTimePlot2D createPlot() {
        return new StackedTimePlot2D(StackedPlot2D.Orientation.VERTICAL, new Epoch(TimeStamp.currentTime()));
    }

    protected void addData(TrackPainter painter, Epoch epoch, double data, TimeStamp time) {
        painter.addPoint(1, 0, epoch.fromTimeStamp(time), data, time.toPosixMillis());
    }

    protected void setBounds(TimePlotInfo chart) {
        Axis1D axis = chart.getLayout().getAxis().getAxisY();
        axis.setMin(-20.0);
        axis.setMax(20.0);
    }
}

