/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.stacked;

import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.axis.tagged.TaggedAxisListener1D;
import com.metsci.glimpse.axis.tagged.TaggedAxisMouseListener1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.stacked.HorizontalTimelinePlotExample;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.plot.stacked.PlotInfo;
import com.metsci.glimpse.plot.timeline.CollapsibleTimePlot2D;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import com.metsci.glimpse.plot.timeline.animate.DragManager;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.data.EventSelection;
import com.metsci.glimpse.plot.timeline.event.Event;
import com.metsci.glimpse.plot.timeline.event.EventPlotInfo;
import com.metsci.glimpse.plot.timeline.event.EventPlotListener;
import com.metsci.glimpse.plot.timeline.event.EventSelectionListener;
import com.metsci.glimpse.plot.timeline.group.GroupInfo;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfo;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.support.settings.OceanLookAndFeel;
import com.metsci.glimpse.util.io.StreamOpener;
import com.metsci.glimpse.util.logging.LoggerUtils;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class CollapsibleTimelinePlotExample
extends HorizontalTimelinePlotExample {
    private static final Logger logger = Logger.getLogger(CollapsibleTimelinePlotExample.class.getName());

    public static void main(String[] args) throws Exception {
        Example example = Example.showWithSwing(new CollapsibleTimelinePlotExample());
        example.getCanvas().setLookAndFeel((LookAndFeel)new OceanLookAndFeel());
        new DragManager((StackedTimePlot2D)((CollapsibleTimePlot2D)example.getLayout()), example.getManager());
    }

    @Override
    protected StackedTimePlot2D createPlot() {
        return new CollapsibleTimePlot2D();
    }

    @Override
    public StackedTimePlot2D getLayout() {
        final CollapsibleTimePlot2D plot = (CollapsibleTimePlot2D)super.getLayout();
        plot.setLabelSize(120);
        for (TimePlotInfo row : plot.getAllTimePlots()) {
            GroupInfo group = plot.createGroup((Object)String.format("%s-group", row.getId()), new PlotInfo[]{row});
            row.getLabelPainter().setText("Label Here");
            group.setLabelText("Group Name");
            this.setPlotLookAndFeel(row);
        }
        EventPlotInfo events1 = plot.createEventPlot((Object)"event-1");
        EventPlotInfo events2 = plot.createEventPlot((Object)"event-2");
        EventPlotInfo events3 = plot.createEventPlot((Object)"event-3");
        events1.setLabelText("Snail Schedule");
        events2.setLabelText("Holidays");
        events3.setLabelText("Weather");
        this.setPlotLookAndFeel((TimePlotInfo)events1);
        this.setPlotLookAndFeel((TimePlotInfo)events2);
        this.setPlotLookAndFeel((TimePlotInfo)events3);
        events1.getLabelPainter().setVerticalPosition(SimpleTextPainter.VerticalPosition.Center);
        events2.getLabelPainter().setVerticalPosition(SimpleTextPainter.VerticalPosition.Center);
        events3.getLabelPainter().setVerticalPosition(SimpleTextPainter.VerticalPosition.Center);
        GroupInfo group = plot.createGroup((Object)"events-group", new PlotInfo[]{events1, events2, events3});
        group.setLabelText("Event Group");
        group.setOrder(100);
        events1.setOrder(2);
        events2.setOrder(3);
        events3.setOrder(4);
        events1.setBackgroundColor(GlimpseColor.getGreen((float)0.6f));
        events1.setBorderColor(GlimpseColor.getGreen());
        events3.setBackgroundColor(GlimpseColor.getCyan((float)0.6f));
        events3.setBorderColor(GlimpseColor.getCyan());
        Epoch e = plot.getEpoch();
        TimeStamp t0 = e.toTimeStamp(0.0);
        Event e0 = events1.addEvent("Wax Shell", t0, t0.add(Time.fromMinutes((double)20.0)));
        e0.setShowBackground(false);
        events1.addEvent("Spread Slime On Stuff", t0.add(Time.fromMinutes((double)30.0)), t0.add(Time.fromMinutes((double)200.0)));
        Event e1 = events1.addEvent("Chill", t0.add(Time.fromMinutes((double)290.0)), t0.add(Time.fromMinutes((double)320.0)));
        e1.setBackgroundColor(GlimpseColor.getRed((float)0.6f));
        e1.setBorderColor(GlimpseColor.getRed());
        Event e2 = events1.addEvent("Cloudy", t0.add(Time.fromMinutes((double)-200.0)), t0.add(Time.fromMinutes((double)100.0)));
        Event e3 = events1.addEvent("Sunny", t0.add(Time.fromMinutes((double)100.0)), t0.add(Time.fromMinutes((double)300.0)));
        Event e4 = events1.addEvent("Wake Up", t0.subtract(Time.fromMinutes((double)40.0)));
        events2.addEvent("Event 1", t0.add(Time.fromMinutes((double)-250.0)), t0.add(Time.fromMinutes((double)-240.0)));
        events2.addEvent("Event 2", t0.add(Time.fromMinutes((double)-220.0)), t0.add(Time.fromMinutes((double)-200.0)));
        events2.addEvent("Event 3", t0.add(Time.fromMinutes((double)-170.0)), t0.add(Time.fromMinutes((double)-100.0)));
        events1.setAggregateNearbyEvents(true);
        events2.setAggregateNearbyEvents(true);
        e0.setEndTimeMoveable(false);
        e1.setResizeable(false);
        e2.setMinTimeSpan(Time.fromMinutes((double)100.0));
        e3.setMaxTimeSpan(Time.fromMinutes((double)500.0));
        events1.getEventSelectionHandler().setClearSelectionOnClick(true);
        e2.setSelectable(false);
        e2.setFixedRow(2);
        events1.validate();
        TextureAtlas atlas = plot.getTextureAtlas();
        try {
            atlas.loadImage((Object)"cloud", ImageIO.read(StreamOpener.fileThenResource.openForRead("icons/fugue/weather-clouds.png")));
            atlas.loadImage((Object)"sun", ImageIO.read(StreamOpener.fileThenResource.openForRead("icons/fugue/weather.png")));
            atlas.loadImage((Object)"glass", ImageIO.read(StreamOpener.fileThenResource.openForRead("icons/fugue/glass.png")));
            atlas.loadImage((Object)"alarm-clock", ImageIO.read(StreamOpener.fileThenResource.openForRead("icons/fugue/alarm-clock-blue.png")));
        }
        catch (IOException ex) {
            LoggerUtils.logWarning((Logger)logger, (String)"Trouble loading icon.", (Throwable)ex, (Object[])new Object[0]);
        }
        e1.setIconId((Object)"glass");
        e2.setIconId((Object)"cloud");
        e3.setIconId((Object)"sun");
        e4.setIconId((Object)"alarm-clock");
        plot.getTooltipPainter().setFixedWidth(300);
        e0.setToolTipText("Wax on. Wax off. Wax on. Wax off. Wax on. Wax off. Wax on. Wax off. Wax on. Wax off.");
        e1.setToolTipText("The Riesling had an elegant, almost austere grip, redolent of creosote and with a corpulent, full-bodied bouquet.");
        e2.setToolTipText("I wandered lonely as a cloud\nThat floats on high o'er vales and hills,\nWhen all at once I saw a crowd,\nA host, of golden daffodils;\nBeside the lake, beneath the trees,\nFluttering and dancing in the breeze.\n-William Wordsworth");
        e3.setToolTipText("NML Cygni = 1,650 Solar Radii");
        e4.setToolTipText("Suns up! Morning's Here!\nUp And At 'Em Engineer!\nHurry! Hurry! Load The Freight!\nTo The City! Can't Be Late!");
        events1.addEventPlotListener(new EventPlotListener(){

            public void eventsHovered(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
                if (!events.isEmpty()) {
                    LoggerUtils.logInfo((Logger)logger, (String)"Events Hovered: %s Time: %s", (Object[])new Object[]{events, time});
                }
            }

            public void eventsClicked(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
                if (!events.isEmpty()) {
                    LoggerUtils.logInfo((Logger)logger, (String)"Events Clicked: %s Time: %s", (Object[])new Object[]{events, time});
                }
            }

            public void eventsExited(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
                if (!events.isEmpty()) {
                    LoggerUtils.logInfo((Logger)logger, (String)"Events Exited: %s Time: %s", (Object[])new Object[]{events, time});
                }
            }

            public void eventsEntered(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
                if (!events.isEmpty()) {
                    LoggerUtils.logInfo((Logger)logger, (String)"Events Entered: %s Time: %s", (Object[])new Object[]{events, time});
                }
            }

            public void eventUpdated(Event event) {
                LoggerUtils.logInfo((Logger)logger, (String)"Event Updated: %s", (Object[])new Object[]{event});
            }
        });
        plot.getEventSelectionHander().addEventSelectionListener(new EventSelectionListener(){

            public void eventsSelected(Set<Event> selectedEvents, Set<Event> deselectedEvents) {
                LoggerUtils.logInfo((Logger)logger, (String)"Selected: %s%nDeselected: %s", (Object[])new Object[]{selectedEvents, deselectedEvents});
            }
        });
        events1.getEventSelectionHandler().setSelectedEventBorderThickness(3.0f);
        plot.setTimeAxisMouseListener((AxisMouseListener1D)new TaggedAxisMouseListener1D());
        plot.getSelectedTimePainter().setShowLockedStatus(false);
        plot.getTimeAxis().addAxisListener((AxisListener1D)new TaggedAxisListener1D(){

            public void tagsUpdated(TaggedAxis1D axis) {
                Tag s = plot.getTimeSelectionTag();
                Tag m = plot.getTimeSelectionMaxTag();
                if (s != null && m != null && s.getValue() != m.getValue()) {
                    s.setValue(m.getValue());
                    axis.validateTags();
                }
            }
        });
        return plot;
    }

    protected void setPlotLookAndFeel(TimePlotInfo row) {
        row.getLabelPainter().setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Left);
        row.getLabelPainter().setVerticalPosition(SimpleTextPainter.VerticalPosition.Top);
        row.getLabelPainter().setHorizontalLabels(true);
        row.getLabelPainter().setFont(FontUtils.getDefaultPlain((float)12.0f), true);
        row.getGridPainter().setShowHorizontalLines(false);
        row.getGridPainter().setShowVerticalLines(true);
        row.getGridPainter().setVisible(true);
        row.getGridPainter().setDotted(false);
        row.getBorderPainter().setDrawBottom(false);
        row.getBorderPainter().setDrawTop(false);
    }
}

