/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.shader;

import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.basic.HeatMapExample;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.metsci.glimpse.gl.texture.Texture;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.texture.ShadedTexturePainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.colormap.ColorGradients;
import com.metsci.glimpse.support.projection.FlatProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.shader.SampledColorScaleShader;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;

public class ShadedTexturePainterExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new ShadedTexturePainterExample());
    }

    public GlimpseLayout getLayout() throws Exception {
        ColorAxisPlot2D plot = new ColorAxisPlot2D();
        ShadedTexturePainter painter = new ShadedTexturePainter();
        SampledColorScaleShader shader = new SampledColorScaleShader(plot.getAxisZ(), 0, 1);
        Pipeline pipeline = new Pipeline("colormap", null, null, (Shader)shader);
        painter.setPipeline(pipeline);
        double[][] data = HeatMapExample.generateData(1000, 1000);
        FlatProjection projection = new FlatProjection(0.0, 1000.0, 0.0, 1000.0);
        FloatTextureProjected2D texture = new FloatTextureProjected2D(1000, 1000);
        texture.setProjection((Projection)projection);
        texture.setData(data);
        painter.addDrawableTexture((DrawableTexture)texture, 0);
        ColorTexture1D colors = new ColorTexture1D(1024);
        colors.setColorGradient(ColorGradients.jet);
        plot.setColorScale(colors);
        painter.addNonDrawableTexture((Texture)colors, 1);
        plot.addPainter((GlimpsePainter)painter);
        plot.setTitle("Heat Map Example");
        plot.setAxisLabelX("x axis");
        plot.setAxisLabelY("y axis");
        plot.setBorderSize(30);
        plot.setAxisSizeX(40);
        plot.setAxisSizeY(60);
        plot.setMinX(0.0);
        plot.setMaxX(1000.0);
        plot.setMinY(0.0);
        plot.setMaxY(1000.0);
        plot.setMinZ(0.0);
        plot.setMaxZ(1000.0);
        plot.lockAspectRatioXY(1.0);
        plot.setSelectionSize(100.0);
        return plot;
    }
}

