/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.shader;

import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.gl.GLCapabilityLogger;
import com.metsci.glimpse.gl.GLSimpleListenerAbstract;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer2D;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.gl.texture.FloatTexture1D;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.adapter.GLSimpleListenerPainter;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.info.FpsPainter;
import com.metsci.glimpse.painter.shape.ShadedPointPainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.colormap.ColorGradients;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Random;

public class PointShaderExample
implements GlimpseLayoutProvider {
    static final int NPOINTS = 100000;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new PointShaderExample());
    }

    public GlimpseAxisLayout2D getLayout() {
        ShadedPointPainter dp;
        final Random r = new Random();
        ColorAxisPlot2D plot = new ColorAxisPlot2D();
        plot.setPlotBackgroundColor(GlimpseColor.getBlack());
        plot.setBackgroundColor(GlimpseColor.getBlack());
        plot.setAxisColor(GlimpseColor.getWhite());
        plot.setTitleColor(GlimpseColor.getWhite());
        plot.getCrosshairPainter().setCursorColor(GlimpseColor.getGreen((float)0.2f));
        plot.getCrosshairPainter().setShadeColor(GlimpseColor.getGreen((float)0.05f));
        plot.getCrosshairPainter().setShadeSelectionBox(true);
        plot.getCrosshairPainter().setLineWidth(1.0f);
        plot.setAxisLabelX("x axis");
        plot.setAxisLabelY("y axis");
        plot.setAxisLabelZ("z axis");
        plot.setTitle("An Impatient Universe");
        plot.setMinX(-3.0);
        plot.setMaxX(3.0);
        plot.setMinY(-3.0);
        plot.setMaxY(3.0);
        plot.setMinZ(0.0);
        plot.setMaxZ(10.0);
        plot.lockAspectRatioXY(1.0);
        plot.addPainter((GlimpsePainter)new GLSimpleListenerPainter((GLSimpleListenerAbstract)new GLCapabilityLogger()));
        try {
            dp = new ShadedPointPainter(plot.getAxisZ(), plot.getAxisZ());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        plot.addPainter((GlimpsePainter)dp);
        ColorTexture1D colors = new ColorTexture1D(256);
        ColorTexture1D.ColorGradientBuilder builder = new ColorTexture1D.ColorGradientBuilder(ColorGradients.jet){

            public void getColor(int index, int size, float[] rgba) {
                super.getColor(index, size, rgba);
                rgba[3] = 0.2f + 0.5f * (float)index / (float)(size - 1);
            }
        };
        colors.mutate((ColorTexture1D.MutatorColor1D)builder);
        dp.useColorScale(colors);
        plot.setColorScale(colors);
        FloatTexture1D sizes = new FloatTexture1D(256);
        FloatTexture1D.MutatorFloat1D sizeMutator = new FloatTexture1D.MutatorFloat1D(){

            public void mutate(FloatBuffer data, int n0) {
                float minSize = 1.0f;
                float maxSize = 12.0f;
                float dSize = maxSize - minSize;
                data.clear();
                for (int i = 0; i < data.capacity(); ++i) {
                    if (i == data.capacity() - 1) {
                        data.put(maxSize * 2.0f);
                        continue;
                    }
                    data.put((float)((double)minSize + (double)dSize * Math.sqrt((float)i / ((float)n0 - 1.0f))));
                }
            }
        };
        sizes.mutate(sizeMutator);
        dp.useSizeScale(sizes);
        final GLFloatBuffer2D positions = new GLFloatBuffer2D(100000);
        positions.mutate(new GLFloatBuffer.Mutator(){

            public void mutate(FloatBuffer data, int length) {
                data.clear();
                for (int i = 0; i < 100000; ++i) {
                    data.put((float)r.nextGaussian());
                    data.put((float)r.nextGaussian());
                }
            }
        });
        final GLFloatBuffer.Mutator positionMutator = new GLFloatBuffer.Mutator(){

            public void mutate(FloatBuffer data, int length) {
                data.clear();
                for (int i = 0; i < 100000; ++i) {
                    data.put((float)((double)data.get(2 * i) + 0.001 * r.nextGaussian()));
                    data.put((float)((double)data.get(2 * i + 1) + 0.001 * r.nextGaussian()));
                }
            }
        };
        dp.useVertexPositionData(positions);
        final GLFloatBuffer colorValues = new GLFloatBuffer(100000, 1);
        final GLFloatBuffer.Mutator colorValueMutator = new GLFloatBuffer.Mutator(){

            public void mutate(FloatBuffer data, int length) {
                data.clear();
                for (int i = 0; i < 100000; ++i) {
                    if (r.nextDouble() > 0.999) {
                        data.put(10.0f * r.nextFloat());
                        continue;
                    }
                    data.put(0.99f * data.get(i));
                }
            }
        };
        colorValues.mutate(colorValueMutator);
        dp.useColorAttribData(colorValues);
        final GLFloatBuffer sizeValues = new GLFloatBuffer(100000, 1);
        final GLFloatBuffer.Mutator sizeValueMutator = new GLFloatBuffer.Mutator(){

            public void mutate(FloatBuffer data, int length) {
                data.clear();
                for (int i = 0; i < 100000; ++i) {
                    if (r.nextDouble() > 0.999) {
                        data.put(10.0f * r.nextFloat());
                        continue;
                    }
                    data.put(0.99f * data.get(i));
                }
            }
        };
        sizeValues.mutate(sizeValueMutator);
        dp.useSizeAttribData(sizeValues);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            positions.mutate(positionMutator);
                            colorValues.mutate(colorValueMutator);
                            sizeValues.mutate(sizeValueMutator);
                            Thread.sleep(10L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
        plot.addPainter((GlimpsePainter)new BorderPainter());
        plot.addPainter((GlimpsePainter)new FpsPainter());
        return plot;
    }
}

