/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.shader;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.AxisUtil;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.info.FpsPainter;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.support.color.RGBA;
import com.metsci.glimpse.support.color.WebColors;
import com.metsci.glimpse.support.shader.geometry.SimpleGeometryShader;
import com.metsci.glimpse.support.shader.geometry.SimpleShader;
import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Random;
import javax.media.opengl.GL;

public class GeometryShaderExample
implements GlimpseLayoutProvider {
    final SimpleGeometryShader[] shaders;
    final int[] inputTypes;
    final Pipeline[] pipelines;
    final String[] pipelineNames;
    int pipelineIndex1;
    int pipelineIndex2;
    int pipelineIndex3;
    private final SimpleTextPainter textLeft = new SimpleTextPainter();
    private final SimpleTextPainter textRight = new SimpleTextPainter();
    private final SimpleTextPainter textCenter = new SimpleTextPainter();
    RGBA[] colors = new RGBA[]{WebColors.CornflowerBlue, WebColors.Salmon, WebColors.ForestGreen};
    private static final float z = 0.0f;
    private static final float w = 1.0f;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new GeometryShaderExample());
    }

    GeometryShaderExample() throws IOException {
        this.shaders = new SimpleGeometryShader[]{SimpleGeometryShader.passGeometry((int)1, (int)3, (int)2), SimpleGeometryShader.linesToXs(), SimpleGeometryShader.pointsToFixedSizeNGons((boolean)false, (int)4, (float)0.0375f), SimpleGeometryShader.linesToVariableSizeNGons((boolean)true, (int)6), SimpleGeometryShader.linesToVariableSizeNGons((boolean)false, (int)3), SimpleGeometryShader.pointsToFixedSizeNGons((boolean)true, (int)5, (float)0.075f), SimpleGeometryShader.pointsToPixelSizedNGons((boolean)false, (int)3, (int)10)};
        this.pipelineNames = new String[]{"pass through lines", "lines into Xs", "points into fixed squares", "lines into solid, variable hexagons", "lines into variable triangles", "points into fixed, solid pentagons", "points into 10 pixel radius triangles"};
        this.pipelines = new Pipeline[this.shaders.length];
        this.inputTypes = new int[this.shaders.length];
        Shader passVertices = SimpleShader.passVertex();
        for (int i = 0; i < this.shaders.length; ++i) {
            this.pipelines[i] = new Pipeline(this.pipelineNames[i], (Shader)this.shaders[i], passVertices, null);
            this.inputTypes[i] = this.shaders[i].inType;
        }
        this.pipelineIndex1 = 0;
        this.pipelineIndex2 = 0;
        this.pipelineIndex3 = 0;
    }

    protected void updateText() {
        this.textLeft.setText(String.format("Left click to change: %s", this.pipelineNames[this.pipelineIndex1]));
        this.textRight.setText(String.format("Right click to change: %s", this.pipelineNames[this.pipelineIndex2]));
        this.textCenter.setText(String.format("Center click to change: %s", this.pipelineNames[this.pipelineIndex3]));
    }

    public GlimpseLayout getLayout() {
        GlimpseAxisLayout2D backgroundLayout = new GlimpseAxisLayout2D(new Axis2D());
        backgroundLayout.addPainter((GlimpsePainter)new BackgroundPainter());
        backgroundLayout.addPainter((GlimpsePainter)new GlimpseDataPainter2D(){
            float[][] xys = null;
            int nRandom = 1000;

            public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axes) {
                int i;
                RGBA color = GeometryShaderExample.this.colors[2];
                gl.glColor3f(color.r, color.g, color.b);
                int ix3 = GeometryShaderExample.this.pipelineIndex3;
                int t3 = GeometryShaderExample.this.inputTypes[ix3];
                Pipeline p3 = GeometryShaderExample.this.pipelines[ix3];
                p3.beginUse(gl);
                gl.glBegin(t3);
                Random r = new Random(new Date().getTime());
                float deltaX = (float)(axes.getMaxX() - axes.getMinX());
                float deltaY = (float)(axes.getMaxX() - axes.getMinX());
                if (this.xys == null) {
                    this.xys = new float[this.nRandom][4];
                    for (i = 0; i < this.nRandom; ++i) {
                        float x0 = r.nextFloat() * deltaX + (float)axes.getMinX();
                        float y0 = r.nextFloat() * deltaY + (float)axes.getMinY();
                        float angle = r.nextFloat() * ((float)Math.PI * 2);
                        float distance = (float)(r.nextGaussian() / 2.0);
                        float x1 = x0 + distance * (float)Math.cos(angle);
                        float y1 = y0 + distance * (float)Math.sin(angle);
                        this.xys[i][0] = x0;
                        this.xys[i][1] = y0;
                        this.xys[i][2] = x1;
                        this.xys[i][3] = y1;
                    }
                }
                for (i = 0; i < this.nRandom; ++i) {
                    float[] fArray = this.xys[i];
                    fArray[0] = (float)((double)fArray[0] + r.nextGaussian() * (double)deltaX / 100.0);
                    float[] fArray2 = this.xys[i];
                    fArray2[1] = (float)((double)fArray2[1] + r.nextGaussian() * (double)deltaX / 100.0);
                    this.xys[i][0] = (float)Math.max(axes.getMinX(), Math.min(axes.getMaxX(), (double)this.xys[i][0]));
                    this.xys[i][1] = (float)Math.max(axes.getMinY(), Math.min(axes.getMaxY(), (double)this.xys[i][1]));
                    this.xys[i][2] = this.xys[i][0] / 5.0f + 4.0f * this.xys[i][2] / 5.0f + (float)(Math.sqrt(deltaX) * r.nextGaussian() / 200.0);
                    this.xys[i][3] = this.xys[i][1] / 5.0f + 4.0f * this.xys[i][3] / 5.0f + (float)(Math.sqrt(deltaY) * r.nextGaussian() / 200.0);
                    gl.glVertex4f(this.xys[i][0], this.xys[i][1], 0.0f, 1.0f);
                    gl.glVertex4f(this.xys[i][2], this.xys[i][3], 0.0f, 1.0f);
                }
                gl.glEnd();
                p3.endUse(gl);
                color = GeometryShaderExample.this.colors[0];
                gl.glColor3f(color.r, color.g, color.b);
                int ix1 = GeometryShaderExample.this.pipelineIndex1;
                int t1 = GeometryShaderExample.this.inputTypes[ix1];
                Pipeline p1 = GeometryShaderExample.this.pipelines[ix1];
                p1.beginUse(gl);
                gl.glBegin(t1);
                int i2 = 0;
                while (i2 < 100) {
                    gl.glVertex4f((float)i2 / 10.0f, (float)i2 / 10.0f, 0.0f, 1.0f);
                    i2 = (int)((double)i2 + (3.0 + 2.0 * Math.cos(i2)));
                }
                gl.glEnd();
                p1.endUse(gl);
                color = GeometryShaderExample.this.colors[1];
                gl.glColor3f(color.r, color.g, color.b);
                int ix2 = GeometryShaderExample.this.pipelineIndex2;
                int t2 = GeometryShaderExample.this.inputTypes[ix2];
                Pipeline p2 = GeometryShaderExample.this.pipelines[ix2];
                p2.beginUse(gl);
                gl.glBegin(t2);
                for (i2 = 0; i2 < 100; i2 += 5) {
                    gl.glVertex4f((float)(100 - i2) / 10.0f, (float)i2 / 10.0f, 0.0f, 1.0f);
                }
                gl.glEnd();
                p2.endUse(gl);
            }
        });
        this.textLeft.setColor(this.colors[0].toFloat4());
        this.textLeft.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Left);
        backgroundLayout.addPainter((GlimpsePainter)this.textLeft);
        this.textRight.setColor(this.colors[1].toFloat4());
        this.textRight.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Right);
        backgroundLayout.addPainter((GlimpsePainter)this.textRight);
        this.textCenter.setColor(this.colors[2].toFloat4());
        this.textCenter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
        this.textCenter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Top);
        backgroundLayout.addPainter((GlimpsePainter)this.textCenter);
        backgroundLayout.addPainter((GlimpsePainter)new FpsPainter());
        this.updateText();
        backgroundLayout.addGlimpseMouseListener(new GlimpseMouseListener(){

            public void mousePressed(GlimpseMouseEvent event) {
                EnumSet buttons = event.getButtons();
                if (buttons.contains(MouseButton.Button1)) {
                    GeometryShaderExample.this.pipelineIndex1 = (GeometryShaderExample.this.pipelineIndex1 + 1) % GeometryShaderExample.this.pipelines.length;
                }
                if (buttons.contains(MouseButton.Button3)) {
                    GeometryShaderExample.this.pipelineIndex2 = (GeometryShaderExample.this.pipelineIndex2 + 1) % GeometryShaderExample.this.pipelines.length;
                }
                if (buttons.contains(MouseButton.Button2)) {
                    GeometryShaderExample.this.pipelineIndex3 = (GeometryShaderExample.this.pipelineIndex3 + 1) % GeometryShaderExample.this.pipelines.length;
                }
                GeometryShaderExample.this.updateText();
            }

            public void mouseReleased(GlimpseMouseEvent event) {
            }

            public void mouseExited(GlimpseMouseEvent event) {
            }

            public void mouseEntered(GlimpseMouseEvent event) {
            }
        });
        AxisUtil.attachMouseListener((GlimpseAxisLayout2D)backgroundLayout);
        return backgroundLayout;
    }
}

