/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.screenshot;

import com.metsci.glimpse.axis.factory.AxisFactory2D;
import com.metsci.glimpse.axis.factory.ConditionalAxisFactory2D;
import com.metsci.glimpse.axis.factory.FixedAxisFactory2D;
import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.canvas.SwingGlimpseCanvas;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.context.TargetStackUtil;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.examples.basic.HeatMapExample;
import com.metsci.glimpse.gl.Jogular;
import com.metsci.glimpse.gl.util.GLPBufferUtils;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.repaint.SwingRepaintManager;
import com.metsci.glimpse.support.screenshot.ScreenshotUtil;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.support.settings.SwingLookAndFeel;
import java.awt.Component;
import java.io.File;
import javax.media.opengl.GLContext;
import javax.swing.JFrame;

public class ScreenCaptureExample {
    public static void main(String[] args) throws Exception {
        Jogular.initJogl();
        GLContext context = GLPBufferUtils.createPixelBuffer((int)1, (int)1).getContext();
        final SwingGlimpseCanvas canvas = new SwingGlimpseCanvas(true, context);
        canvas.addLayout((GlimpseLayout)new ScreenCaptureExample().getLayout(context));
        canvas.setLookAndFeel((LookAndFeel)new SwingLookAndFeel());
        SwingRepaintManager manager = SwingRepaintManager.newRepaintManager((GlimpseCanvas)canvas);
        JFrame frame = new JFrame("Glimpse Example");
        frame.add((Component)canvas);
        frame.pack();
        frame.setSize(800, 800);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        Runtime.getRuntime().addShutdownHook(new Thread((RepaintManager)manager){
            final /* synthetic */ RepaintManager val$manager;
            {
                this.val$manager = repaintManager;
            }

            @Override
            public void run() {
                canvas.dispose(this.val$manager);
            }
        });
    }

    public ColorAxisPlot2D getLayout(GLContext context) {
        HeatMapExample heatMapExample = new HeatMapExample();
        final ColorAxisPlot2D heatMapPlot = heatMapExample.getLayout();
        heatMapPlot.setTitleFont(FontUtils.getDefaultBold((float)18.0f));
        heatMapPlot.setTitle("Click Center Mouse Button To Take Screenshot");
        final ScreenshotUtil screenshot = new ScreenshotUtil(context);
        GlimpseTargetStack stack = TargetStackUtil.newTargetStack((GlimpseTarget[])new GlimpseTarget[]{screenshot.getGlimpseCanvas()});
        FixedAxisFactory2D factory = new FixedAxisFactory2D(0.0, 1000.0, 0.0, 1000.0);
        heatMapPlot.setAxisFactory((AxisFactory2D)new ConditionalAxisFactory2D(stack, (AxisFactory2D)factory));
        heatMapPlot.addGlimpseMouseListener(new GlimpseMouseListener(){

            public void mousePressed(GlimpseMouseEvent event) {
                if (event.isButtonDown(MouseButton.Button2)) {
                    try {
                        File screenshotFile = new File("ScreenCaptureExample.png");
                        screenshot.captureScreenshot((GlimpseLayout)heatMapPlot, screenshotFile, 3000, 3000);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void mouseEntered(GlimpseMouseEvent event) {
            }

            public void mouseExited(GlimpseMouseEvent event) {
            }

            public void mouseReleased(GlimpseMouseEvent event) {
            }
        });
        return heatMapPlot;
    }
}

