/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.projection;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.AxisUtil;
import com.metsci.glimpse.canvas.FrameBufferGlimpseCanvas;
import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.canvas.SwingGlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.examples.basic.HeatMapExample;
import com.metsci.glimpse.gl.Jogular;
import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.metsci.glimpse.gl.util.GLPBufferUtils;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.texture.ShadedTexturePainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.projection.PolarProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.repaint.SwingRepaintManager;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.support.settings.SwingLookAndFeel;
import com.metsci.glimpse.support.texture.TextureProjected2D;
import java.awt.Component;
import javax.media.opengl.GLContext;
import javax.swing.JFrame;

public class ReprojectionExample {
    public static void main(String[] args) throws Exception {
        Jogular.initJogl();
        GLContext context = GLPBufferUtils.createPixelBuffer((int)1, (int)1).getContext();
        final SwingGlimpseCanvas canvas = new SwingGlimpseCanvas(true, context);
        ColorAxisPlot2D layout = new HeatMapExample().getLayout();
        canvas.addLayout((GlimpseLayout)layout);
        canvas.setLookAndFeel((LookAndFeel)new SwingLookAndFeel());
        SwingRepaintManager manager = SwingRepaintManager.newRepaintManager((GlimpseCanvas)canvas);
        FrameBufferGlimpseCanvas offscreenCanvas = new FrameBufferGlimpseCanvas(800, 800, context);
        offscreenCanvas.addLayout((GlimpseLayout)layout);
        manager.addGlimpseCanvas((GlimpseCanvas)offscreenCanvas);
        SwingGlimpseCanvas canvas2 = new SwingGlimpseCanvas(true, context);
        canvas2.addLayout(new ReprojectionExample().getLayout(offscreenCanvas));
        canvas2.setLookAndFeel((LookAndFeel)new SwingLookAndFeel());
        manager.addGlimpseCanvas((GlimpseCanvas)canvas2);
        ReprojectionExample.createFrame("Original", canvas);
        ReprojectionExample.createFrame("Reprojected", canvas2);
        Runtime.getRuntime().addShutdownHook(new Thread((RepaintManager)manager, canvas2, offscreenCanvas){
            final /* synthetic */ RepaintManager val$manager;
            final /* synthetic */ SwingGlimpseCanvas val$canvas2;
            final /* synthetic */ FrameBufferGlimpseCanvas val$offscreenCanvas;
            {
                this.val$manager = repaintManager;
                this.val$canvas2 = swingGlimpseCanvas2;
                this.val$offscreenCanvas = frameBufferGlimpseCanvas;
            }

            @Override
            public void run() {
                canvas.dispose(this.val$manager);
                this.val$canvas2.dispose(this.val$manager);
                this.val$offscreenCanvas.dispose(this.val$manager);
            }
        });
    }

    public static JFrame createFrame(String name, SwingGlimpseCanvas canvas) {
        JFrame frame = new JFrame(name);
        frame.add((Component)canvas);
        frame.pack();
        frame.setSize(800, 800);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        return frame;
    }

    public GlimpseLayout getLayout(final FrameBufferGlimpseCanvas offscreenCanvas) throws Exception {
        Axis2D axis = new Axis2D();
        axis.set(-10.0, 10.0, -10.0, 10.0);
        GlimpseAxisLayout2D layout2 = new GlimpseAxisLayout2D(axis);
        AxisUtil.attachMouseListener((GlimpseAxisLayout2D)layout2);
        ShadedTexturePainter painter = new ShadedTexturePainter(){
            boolean initialized = false;

            public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
                super.paintTo(context, bounds, axis);
                if (!this.initialized && offscreenCanvas.getFrameBuffer().isInitialized()) {
                    TextureProjected2D texture = offscreenCanvas.getGlimpseTexture();
                    texture.setProjection((Projection)new PolarProjection(0.0, 10.0, 0.0, 360.0));
                    this.addDrawableTexture((DrawableTexture)texture);
                    this.initialized = true;
                }
            }
        };
        layout2.addPainter((GlimpsePainter)new BackgroundPainter(true));
        layout2.addPainter((GlimpsePainter)painter);
        return layout2;
    }
}

