/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.projection;

import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.basic.HeatMapExample;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.info.CursorTextZPainter;
import com.metsci.glimpse.painter.texture.HeatMapPainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.colormap.ColorGradients;
import com.metsci.glimpse.support.projection.GenericProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;

public class GenericProjectionExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new GenericProjectionExample());
    }

    public GlimpseLayout getLayout() throws Exception {
        ColorAxisPlot2D plot = new ColorAxisPlot2D();
        plot.setTitle("Heat Map Example");
        plot.setAxisLabelX("x axis");
        plot.setAxisLabelY("y axis");
        plot.setMinX(0.0);
        plot.setMaxX(1000.0);
        plot.setMinY(0.0);
        plot.setMaxY(1000.0);
        plot.setMinZ(0.0);
        plot.setMaxZ(1000.0);
        plot.lockAspectRatioXY(1.0);
        plot.setSelectionSize(100.0);
        double[][] data = HeatMapExample.generateData(1000, 1000);
        double[][] vertexX = new double[2][3];
        vertexX[0][0] = -10.0;
        vertexX[1][0] = 1200.0;
        vertexX[0][1] = 0.0;
        vertexX[1][1] = 1000.0;
        vertexX[0][2] = -100.0;
        vertexX[1][2] = 500.0;
        double[][] vertexY = new double[2][3];
        vertexY[0][0] = 30.0;
        vertexY[1][0] = 100.0;
        vertexY[0][1] = 1000.0;
        vertexY[1][1] = 2000.0;
        vertexY[0][2] = 1500.0;
        vertexY[1][2] = 2500.0;
        GenericProjection projection = new GenericProjection(vertexX, vertexY);
        FloatTextureProjected2D texture = new FloatTextureProjected2D(1000, 1000);
        texture.setProjection((Projection)projection);
        texture.setData(data);
        ColorTexture1D colors = new ColorTexture1D(1024);
        colors.setColorGradient(ColorGradients.jet);
        HeatMapPainter heatmap = new HeatMapPainter(plot.getAxisZ());
        heatmap.setData(texture);
        heatmap.setColorScale(colors);
        plot.addPainter((GlimpsePainter)heatmap);
        plot.setColorScale(colors);
        plot.addPainter((GlimpsePainter)heatmap);
        CursorTextZPainter cursorPainter = new CursorTextZPainter();
        plot.addPainter((GlimpsePainter)cursorPainter);
        cursorPainter.setTexture(texture);
        return plot;
    }
}

