/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.misc;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.UpdateMode;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.info.CursorTextPainter;
import com.metsci.glimpse.painter.treemap.NestedTreeMap;
import com.metsci.glimpse.painter.treemap.SimpleTreeMapPainter;
import com.metsci.glimpse.painter.treemap.SquarifiedLayout;
import com.metsci.glimpse.painter.treemap.TreeMapLayout;
import com.metsci.glimpse.plot.Plot2D;
import com.metsci.glimpse.support.colormap.ColorGradient;
import com.metsci.glimpse.support.colormap.ColorGradients;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeMap;
import java.util.zip.ZipInputStream;

public class TreeMapExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new TreeMapExample());
    }

    public GlimpseLayout getLayout() throws Exception {
        Plot2D plot = new Plot2D("treemap");
        plot.setAxisSizeX(0);
        plot.setAxisSizeY(0);
        plot.setAxisSizeZ(0);
        plot.setTitle("TreeMap of States");
        NestedTreeMap tree = TreeMapExample.createLargeGeoTree();
        SimpleTreeMapPainter painter = new SimpleTreeMapPainter(){
            ColorGradient scale = ColorGradients.jet;

            protected float[] getTitleBackgroundColor(int nodeId, boolean selected) {
                int level = this.tree.getLevel(nodeId);
                float[] color = new float[4];
                this.scale.toColor((float)level / 5.0f, color);
                if (selected) {
                    color[0] = color[0] * 0.4f;
                    color[1] = color[1] * 0.4f;
                    color[2] = color[2] * 0.4f;
                }
                return color;
            }
        };
        painter.setTreeMapData(tree);
        plot.getLayoutCenter().addPainter((GlimpsePainter)painter, Plot2D.DATA_LAYER);
        plot.getLayoutCenter().addPainter((GlimpsePainter)new TreeMapHoverPainter(painter), Plot2D.FOREGROUND_LAYER);
        plot.setAbsoluteMinX(0.0);
        plot.setAbsoluteMaxX(100.0);
        plot.setAbsoluteMinY(0.0);
        plot.setAbsoluteMaxY(100.0);
        plot.getAxisX().setUpdateMode(UpdateMode.FixedPixel);
        plot.getAxisY().setUpdateMode(UpdateMode.FixedPixel);
        plot.setMinX(plot.getAxisX().getAbsoluteMin());
        plot.setMaxX(plot.getAxisX().getAbsoluteMax());
        plot.setMinY(plot.getAxisY().getAbsoluteMin());
        plot.setMaxY(plot.getAxisY().getAbsoluteMax());
        painter.setLayout((TreeMapLayout)new SquarifiedLayout());
        return plot;
    }

    static NestedTreeMap createLargeGeoTree() throws Exception {
        NestedTreeMap tree = new NestedTreeMap();
        tree.setRoot(0);
        tree.setTitle(0, "US");
        int idGenerator = 100;
        TreeMap<String, Integer> stateIdMap = new TreeMap<String, Integer>();
        TreeMap<String, Integer> countyIdMap = new TreeMap<String, Integer>();
        InputStream fileStream = StreamOpener.resource.openForRead("data/us_inc_civil_pop_2009.zip");
        ZipInputStream zipStream = new ZipInputStream(fileStream);
        zipStream.getNextEntry();
        BufferedReader reader = new BufferedReader(new InputStreamReader(zipStream));
        reader.readLine();
        reader.readLine();
        String line = null;
        while ((line = reader.readLine()) != null) {
            int id;
            String[] parts = line.split("\t");
            String level = parts[0];
            String county = parts[1];
            String city = parts[2];
            String state = parts[3];
            int population = Integer.parseInt(parts[15]);
            String text = "Total Pop: " + population;
            if ("0".equals(level)) {
                int id2 = idGenerator++;
                stateIdMap.put(state, id2);
                tree.addChild(0, id2, (double)population, state);
                tree.setText(id2, text);
                continue;
            }
            if ("1".equals(level)) {
                int stateId = (Integer)stateIdMap.get(state);
                id = idGenerator++;
                countyIdMap.put(county, id);
                tree.addChild(stateId, id, (double)population, "(no county)".equals(county) ? city : county);
                tree.setText(id, text);
                continue;
            }
            if (!"2".equals(level)) continue;
            int countyId = (Integer)countyIdMap.get(county);
            id = idGenerator++;
            tree.addChild(countyId, id, (double)population, city);
            tree.setText(id, text);
        }
        reader.close();
        return tree;
    }

    class TreeMapHoverPainter
    extends CursorTextPainter {
        SimpleTreeMapPainter painter;
        Integer selectedLeafId;

        TreeMapHoverPainter(SimpleTreeMapPainter painter) {
            this.painter = painter;
        }

        public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
            double x = axis.getAxisX().getSelectionCenter();
            double y = axis.getAxisY().getSelectionCenter();
            this.selectedLeafId = this.painter.getLeafAt(axis, x, y);
            if (this.selectedLeafId != null) {
                super.paintTo(context, bounds, axis);
            }
        }

        protected String getTextX(Axis2D axis) {
            NestedTreeMap tree = this.painter.getTreeMapData();
            StringBuilder builder = new StringBuilder();
            int id = this.selectedLeafId;
            while (id != tree.getRoot()) {
                String title = tree.getTitle(id);
                builder.append(title);
                builder.append(" < ");
                id = tree.getParent(id);
            }
            builder.append(tree.getTitle(id));
            return builder.toString();
        }

        protected String getTextY(Axis2D axis) {
            double size = this.painter.getTreeMapData().getSize(this.selectedLeafId.intValue());
            return String.format("Population: %d", (int)size);
        }
    }
}

