/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.misc;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.AxisListener2D;
import com.metsci.glimpse.axis.listener.RateLimitedAxisListener2D;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.info.FpsPainter;
import com.metsci.glimpse.painter.shape.DynamicPointSetPainter;
import com.metsci.glimpse.plot.SimplePlot2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.util.Collection;
import java.util.logging.Logger;

public class DynamicPointPainterExample
implements GlimpseLayoutProvider {
    private static final Logger logger = Logger.getLogger(DynamicPointPainterExample.class.getName());

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new DynamicPointPainterExample());
    }

    public SimplePlot2D getLayout() {
        SimplePlot2D plot = new SimplePlot2D();
        plot.getAxis().set(-1.0, 2.0, -1.0, 2.0);
        final DynamicPointSetPainter painter = new DynamicPointSetPainter();
        plot.addPainter((GlimpsePainter)painter);
        plot.addPainter((GlimpsePainter)new FpsPainter());
        new Thread(){
            int count = 0;

            @Override
            public void run() {
                try {
                    while (this.count < 50000) {
                        DynamicPointSetPainter.BulkPointAccumulator accum = new DynamicPointSetPainter.BulkPointAccumulator();
                        float[] color = GlimpseColor.fromColorRgba((float)((float)Math.random()), (float)((float)Math.random()), (float)((float)Math.random()), (float)((float)Math.random()));
                        for (int i = 0; i < 500; ++i) {
                            accum.add((Object)this.count++, (float)Math.random(), (float)Math.random(), color);
                        }
                        painter.putPoints(accum);
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        logger.info("Total Points: " + this.count);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        plot.addAxisListener((AxisListener2D)new RateLimitedAxisListener2D(){

            public void axisUpdatedRateLimited(Axis2D axis) {
                double centerX = axis.getAxisX().getSelectionCenter();
                double sizeX = axis.getAxisX().getSelectionSize();
                double centerY = axis.getAxisY().getSelectionCenter();
                double sizeY = axis.getAxisY().getSelectionSize();
                Collection selection = painter.getGeoRange(centerX - sizeX / 2.0, centerX + sizeX / 2.0, centerY - sizeY / 2.0, centerY + sizeY / 2.0);
                LoggerUtils.logInfo((Logger)logger, (String)"Selected Ids: %s", (Object[])new Object[]{selection});
            }
        });
        return plot;
    }
}

