/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.listener;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener2D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.plot.SimplePlot2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;

public class MouseDrawingExample
implements GlimpseLayoutProvider {
    protected TrackPainter painter;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new MouseDrawingExample());
    }

    public GlimpseLayout getLayout() throws Exception {
        SimplePlot2D plot = new SimplePlot2D(){

            protected AxisMouseListener createAxisMouseListenerXY() {
                return new CustomMouseListener2D();
            }
        };
        plot.setTitleHeight(0);
        plot.setAxisSizeX(0);
        plot.setAxisSizeY(0);
        plot.getCrosshairPainter().setVisible(false);
        this.painter = new TrackPainter();
        plot.addPainter((GlimpsePainter)this.painter);
        this.painter.setPointColor(1, GlimpseColor.getRed());
        this.painter.setPointSize(1, 10.0f);
        this.painter.setShowLines(1, false);
        this.painter.setShowPoints(2, false);
        this.painter.setShowLines(2, true);
        this.painter.setDotted(2, false);
        this.painter.setLineColor(2, GlimpseColor.getGreen());
        this.painter.setLineWidth(2, 2.5f);
        SimpleTextPainter text = new SimpleTextPainter();
        text.setText("Hold Shift to draw. Right Click to add dot.");
        text.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
        text.setVerticalPosition(SimpleTextPainter.VerticalPosition.Top);
        text.setFont(FontUtils.getDefaultBold((float)16.0f));
        plot.addPainter((GlimpsePainter)text);
        return plot;
    }

    public class CustomMouseListener2D
    extends AxisMouseListener2D {
        int id1 = 0;
        int id2 = 0;

        public void mouseMoved(GlimpseMouseEvent event) {
            if (event.isButtonDown(MouseButton.Button1) && event.isKeyDown(ModifierKey.Shift)) {
                double x = event.getAxisCoordinatesX();
                double y = event.getAxisCoordinatesY();
                MouseDrawingExample.this.painter.addPoint(2, this.id1++, x, y, 0L);
            } else {
                super.mouseMoved(event);
            }
        }

        public void mousePressed(GlimpseMouseEvent event) {
            Axis2D axis = event.getAxis2D();
            Axis1D axisX = axis.getAxisX();
            Axis1D axisY = axis.getAxisY();
            if (event.isButtonDown(MouseButton.Button3)) {
                double x = axisX.screenPixelToValue((double)event.getX());
                double y = axisY.screenPixelToValue((double)(axisY.getSizePixels() - event.getY()));
                MouseDrawingExample.this.painter.addPoint(1, this.id2++, x, y, 0L);
            }
            super.mousePressed(event);
        }
    }
}

