/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.layout;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.canvas.SwingGlimpseCanvas;
import com.metsci.glimpse.examples.layout.SimpleLayoutExample;
import com.metsci.glimpse.gl.Jogular;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.repaint.SwingRepaintManager;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.support.settings.SwingLookAndFeel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class SimpleLayoutExampleWithPopup {
    private static final Logger logger = Logger.getLogger(SimpleLayoutExampleWithPopup.class.getName());

    public static void main(String[] args) throws Exception {
        Jogular.initJogl();
        final SwingGlimpseCanvas canvas = new SwingGlimpseCanvas(true);
        GlimpseLayout plot = SimpleLayoutExampleWithPopup.buildPlot(canvas);
        canvas.addLayout(plot);
        canvas.setLookAndFeel((LookAndFeel)new SwingLookAndFeel());
        SwingRepaintManager manager = SwingRepaintManager.newRepaintManager((GlimpseCanvas)canvas);
        JFrame frame = new JFrame("Glimpse Example (Swing)");
        frame.add((Component)canvas);
        frame.pack();
        frame.setSize(800, 800);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        Runtime.getRuntime().addShutdownHook(new Thread((RepaintManager)manager){
            final /* synthetic */ RepaintManager val$manager;
            {
                this.val$manager = repaintManager;
            }

            @Override
            public void run() {
                canvas.dispose(this.val$manager);
            }
        });
    }

    protected static GlimpseLayout buildPlot(final SwingGlimpseCanvas canvas) throws Exception {
        GlimpseLayout layout = new SimpleLayoutExample().getLayout();
        final JPopupMenu _popupMenu = SimpleLayoutExampleWithPopup.createPopupMenu();
        canvas.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 3) {
                    _popupMenu.show((Component)canvas, arg0.getX(), arg0.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        return layout;
    }

    private static JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JRadioButtonMenuItem item1 = new JRadioButtonMenuItem("Item1", false);
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.info("clicked item1");
            }
        });
        JRadioButtonMenuItem item2 = new JRadioButtonMenuItem("Item2", false);
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.info("clicked item2");
            }
        });
        popupMenu.add(item1);
        popupMenu.add(item2);
        return popupMenu;
    }
}

