/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.layout;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.AxisListener2D;
import com.metsci.glimpse.axis.painter.NumericAxisPainter;
import com.metsci.glimpse.axis.painter.NumericRotatedYAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.basic.HeatMapExample;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.plot.SimplePlot2D;
import com.metsci.glimpse.support.font.FontUtils;

public class FloatingLayoutExample
implements GlimpseLayoutProvider {
    protected int plotHeight = 200;
    protected int plotWidth = 200;
    protected double plotMinX = 0.0;
    protected double plotMinY = 0.0;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new FloatingLayoutExample());
    }

    public GlimpseLayout getLayout() {
        final SimplePlot2D plot = new SimplePlot2D();
        final GlimpseLayout floatingLayout = new GlimpseLayout();
        SimplePlot2D floatingPlot = new SimplePlot2D(){

            protected NumericAxisPainter createAxisPainterY(AxisLabelHandler tickHandler) {
                return new NumericRotatedYAxisPainter(tickHandler);
            }
        };
        plot.addAxisListener(new AxisListener2D(){

            public void axisUpdated(Axis2D axis) {
                int minX = plot.getAxisX().valueToScreenPixel(FloatingLayoutExample.this.plotMinX);
                int minY = plot.getAxisY().valueToScreenPixel(FloatingLayoutExample.this.plotMinY);
                floatingLayout.setLayoutData((Object)String.format("pos %d %d %d %d", minX, minY, minX + FloatingLayoutExample.this.plotWidth, minY + FloatingLayoutExample.this.plotHeight));
                plot.invalidateLayout();
            }
        });
        plot.getLayoutCenter().addGlimpseMouseListener(new GlimpseMouseListener(){

            public void mousePressed(GlimpseMouseEvent event) {
                if (event.isButtonDown(MouseButton.Button2)) {
                    FloatingLayoutExample.this.plotMinX = event.getAxisCoordinatesX();
                    FloatingLayoutExample.this.plotMinY = event.getAxisCoordinatesY();
                }
            }

            public void mouseEntered(GlimpseMouseEvent event) {
            }

            public void mouseExited(GlimpseMouseEvent event) {
            }

            public void mouseReleased(GlimpseMouseEvent event) {
            }
        });
        floatingPlot.setAxisFont(FontUtils.getSilkscreen(), false);
        floatingPlot.setAxisSizeX(25);
        floatingPlot.setAxisSizeY(25);
        floatingPlot.setTickSpacingX(35);
        floatingPlot.setTickSpacingY(35);
        floatingPlot.setBorderSize(4);
        floatingPlot.getCrosshairPainter().setVisible(false);
        plot.getCrosshairPainter().setVisible(false);
        floatingPlot.setTitleHeight(0);
        floatingLayout.addPainter((GlimpsePainter)new BorderPainter().setLineWidth(2.0f), Integer.MAX_VALUE);
        Axis1D colorAxis = new Axis1D();
        colorAxis.setMin(0.0);
        colorAxis.setMax(1000.0);
        floatingPlot.addPainter((GlimpsePainter)HeatMapExample.newHeatMapPainter(colorAxis));
        floatingPlot.getAxis().set(0.0, 1000.0, 0.0, 1000.0);
        plot.addPainter((GlimpsePainter)HeatMapExample.newHeatMapPainter(colorAxis));
        plot.getAxis().set(0.0, 1000.0, 0.0, 1000.0);
        floatingLayout.addLayout((GlimpseLayout)floatingPlot);
        plot.getLayoutCenter().addLayout(floatingLayout);
        plot.getLayoutCenter().invalidateLayout();
        plot.setAxisSizeY(45);
        plot.setAxisSizeX(30);
        plot.setTitleHeight(0);
        return plot;
    }
}

