/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.icon;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener2D;
import com.metsci.glimpse.axis.painter.NumericXYAxisPainter;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.event.mouse.GlimpseMouseAllListener;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.support.atlas.support.ImageDrawer;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.util.io.StreamOpener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;

public class TextureAtlasExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new TextureAtlasExample());
    }

    public GlimpseLayout getLayout() throws Exception {
        TextureAtlas atlas = new TextureAtlas(512, 512);
        TextureAtlasExample.loadTextureAtlas(atlas);
        GlimpseAxisLayout2D layout = new GlimpseAxisLayout2D(new Axis2D());
        layout.addGlimpseMouseAllListener((GlimpseMouseAllListener)new AxisMouseListener2D());
        layout.addPainter((GlimpsePainter)new BackgroundPainter().setColor(GlimpseColor.getWhite()));
        layout.addPainter((GlimpsePainter)new NumericXYAxisPainter());
        layout.addPainter((GlimpsePainter)new SimpleIconPainter(atlas));
        return layout;
    }

    public static void loadTextureAtlas(TextureAtlas atlas) throws IOException {
        atlas.loadImage((Object)"image1", 30, 30, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.red);
                g.fillRect(0, 0, width, height);
            }
        });
        atlas.loadImage((Object)"image2", 100, 100, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.blue);
                g.fillRect(0, 0, width, height);
            }
        });
        atlas.loadImage((Object)"image3", 100, 100, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.yellow);
                g.drawArc(0, 0, width, height, 0, 360);
            }
        });
        atlas.loadImage((Object)"image4", 80, 80, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.CYAN);
                g.fillArc(0, 0, width, height, 0, 360);
            }
        });
        atlas.loadImage((Object)"image5", 70, 70, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.black);
                g.drawLine(width, 0, 0, height);
                g.drawLine(0, 0, width, height);
            }
        });
        atlas.loadImage((Object)"image6", 10, 10, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.black);
                g.drawLine(width, 0, 0, height);
                g.drawLine(0, 0, width, height);
            }
        });
        atlas.loadImage((Object)"image7", 100, 100, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.red);
                g.fillRect(0, 0, width / 2, height / 2);
                g.fillRect(width / 2, height / 2, width / 2, height / 2);
                g.setColor(Color.blue);
                g.fillRect(0, height / 2, width / 2, height / 2);
                g.fillRect(width / 2, 0, width / 2, height / 2);
            }
        });
        atlas.loadImage((Object)"image8", 200, 100, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.green);
                g.fillRect(0, 0, width / 2, height / 2);
                g.fillRect(width / 2, height / 2, width / 2, height / 2);
                g.setColor(Color.yellow);
                g.fillRect(0, height / 2, width / 2, height / 2);
                g.fillRect(width / 2, 0, width / 2, height / 2);
            }
        });
        atlas.loadImage((Object)"image9", 100, 100, 0, 0, new ImageDrawer(){

            public void drawImage(Graphics2D g, int width, int height) {
                g.setColor(Color.black);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        if ((x % 2 != 0 || y % 2 != 0) && (x % 2 == 0 || y % 2 == 0)) continue;
                        g.fillRect(x, y, 1, 1);
                    }
                }
                g.setColor(Color.red);
                g.drawRect(0, 0, width - 1, height - 1);
            }
        });
        atlas.loadImage((Object)"glimpse", ImageIO.read(StreamOpener.fileThenResource.openForRead("images/GlimpseLogo.png")));
    }

    public class SimpleIconPainter
    extends GlimpseDataPainter2D {
        protected TextureAtlas atlas;

        public SimpleIconPainter(TextureAtlas atlas) {
            this.atlas = atlas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
            this.atlas.beginRendering();
            try {
                this.atlas.drawImage(gl, (Object)"image1", axis, 0.0, 0.0, 0.5, 1.0);
                this.atlas.drawImage(gl, (Object)"glimpse", axis, 0.0, 0.0, 0.5);
                this.atlas.drawImage(gl, (Object)"glimpse", axis, 5.0, 4.0, 0.5);
            }
            finally {
                this.atlas.endRendering();
            }
        }
    }
}

