/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.icon;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener2D;
import com.metsci.glimpse.axis.painter.NumericXYAxisPainter;
import com.metsci.glimpse.event.mouse.GlimpseMouseAllListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.icon.TextureAtlasExample;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.info.FpsPainter;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.support.atlas.painter.IconPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.selection.SpatialSelectionListener;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.util.Collection;
import java.util.logging.Logger;

public class IconPainterExample
implements GlimpseLayoutProvider {
    private static final Logger logger = Logger.getLogger(IconPainterExample.class.getName());

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new IconPainterExample());
    }

    public GlimpseLayout getLayout() throws Exception {
        GlimpseAxisLayout2D layout = new GlimpseAxisLayout2D(new Axis2D());
        layout.addGlimpseMouseAllListener((GlimpseMouseAllListener)new AxisMouseListener2D());
        TextureAtlas atlas = new TextureAtlas(256, 256);
        final IconPainter iconPainter = new IconPainter();
        iconPainter.addIconGroup((Object)"group1", atlas);
        iconPainter.addIconGroup((Object)"group2", atlas);
        iconPainter.setPickingEnabled((GlimpseLayout)layout);
        iconPainter.addSpatialSelectionListener((SpatialSelectionListener)new SpatialSelectionListener<IconPainter.PickResult>(){

            public void selectionChanged(Collection<IconPainter.PickResult> newSelectedPoints) {
                LoggerUtils.logInfo((Logger)logger, (String)"Selection: %s", (Object[])new Object[]{newSelectedPoints});
            }
        });
        TextureAtlasExample.loadTextureAtlas(atlas);
        iconPainter.addIcons((Object)"group1", (Object)"image9", new float[]{0.0f, 20.0f, 30.0f, 40.0f}, new float[]{0.0f, 20.0f, 30.0f, 40.0f}, new float[]{1.0471976f, -1.0471976f, 0.0f, 0.0f}, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        layout.addGlimpseMouseListener(new GlimpseMouseListener(){
            float rot = 0.0f;

            public void mouseEntered(GlimpseMouseEvent event) {
            }

            public void mouseExited(GlimpseMouseEvent event) {
            }

            public void mousePressed(GlimpseMouseEvent event) {
                float x = (float)event.getAxisCoordinatesX();
                float y = (float)event.getAxisCoordinatesY();
                if (event.isButtonDown(MouseButton.Button1)) {
                    iconPainter.addIcon((Object)"group2", (Object)"image7", x, y, this.rot, 0.5f);
                } else if (event.isButtonDown(MouseButton.Button2)) {
                    iconPainter.addIcon((Object)"group2", (Object)"glimpse", x, y, this.rot, 0.5f);
                } else if (event.isButtonDown(MouseButton.Button3)) {
                    iconPainter.addIcon((Object)"group2", (Object)"image9", x, y, this.rot, 1.0f);
                }
                this.rot = (float)((double)this.rot + 0.2617993877991494);
            }

            public void mouseReleased(GlimpseMouseEvent event) {
            }
        });
        layout.addPainter((GlimpsePainter)new BackgroundPainter().setColor(GlimpseColor.getWhite()));
        layout.addPainter((GlimpsePainter)new NumericXYAxisPainter());
        layout.addPainter((GlimpsePainter)iconPainter);
        layout.addPainter((GlimpsePainter)new FpsPainter());
        return layout;
    }
}

