/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.basic;

import com.metsci.glimpse.axis.tagged.Constraint;
import com.metsci.glimpse.axis.tagged.NamedConstraint;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.basic.HeatMapExample;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.info.CursorTextZPainter;
import com.metsci.glimpse.painter.texture.TaggedHeatMapPainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.plot.TaggedColorAxisPlot2D;
import com.metsci.glimpse.support.colormap.ColorGradients;
import com.metsci.glimpse.support.projection.FlatProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;

public class TaggedHeatMapExample
implements GlimpseLayoutProvider {
    TaggedHeatMapPainter heatmap;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new TaggedHeatMapExample());
    }

    public ColorAxisPlot2D getLayout() {
        TaggedColorAxisPlot2D plot = new TaggedColorAxisPlot2D();
        TaggedAxis1D axisZ = plot.getAxisZ();
        final Tag t1 = axisZ.addTag("T1", 50.0).setAttribute("TexCoord", (Object)Float.valueOf(0.0f));
        final Tag t2 = axisZ.addTag("T2", 300.0).setAttribute("TexCoord", (Object)Float.valueOf(0.3f));
        final Tag t3 = axisZ.addTag("T3", 500.0).setAttribute("TexCoord", (Object)Float.valueOf(0.6f));
        final Tag t4 = axisZ.addTag("T4", 600.0).setAttribute("TexCoord", (Object)Float.valueOf(0.8f));
        final Tag t5 = axisZ.addTag("T5", 800.0).setAttribute("TexCoord", (Object)Float.valueOf(1.0f));
        axisZ.addConstraint((Constraint)new NamedConstraint("C1"){
            static final double buffer = 1.0;

            public void applyConstraint(TaggedAxis1D axis) {
                if (t4.getValue() > t5.getValue() - 1.0) {
                    t4.setValue(t5.getValue() - 1.0);
                }
                if (t3.getValue() > t4.getValue() - 1.0) {
                    t3.setValue(t4.getValue() - 1.0);
                }
                if (t2.getValue() > t3.getValue() - 1.0) {
                    t2.setValue(t3.getValue() - 1.0);
                }
                if (t1.getValue() > t2.getValue() - 1.0) {
                    t1.setValue(t2.getValue() - 1.0);
                }
            }
        });
        plot.setBorderSize(15);
        plot.setAxisSizeX(30);
        plot.setAxisSizeY(40);
        plot.setTitleHeight(0);
        plot.setMinX(0.0);
        plot.setMaxX(1000.0);
        plot.setMinY(0.0);
        plot.setMaxY(1000.0);
        plot.setMinZ(0.0);
        plot.setMaxZ(1000.0);
        plot.lockAspectRatioXY(1.0);
        plot.setSelectionSize(100.0);
        double[][] data = HeatMapExample.generateData(1000, 1000);
        FlatProjection projection = new FlatProjection(0.0, 1000.0, 0.0, 1000.0);
        FloatTextureProjected2D texture = new FloatTextureProjected2D(1000, 1000);
        texture.setProjection((Projection)projection);
        texture.setData(data);
        ColorTexture1D colors = new ColorTexture1D(1024);
        colors.setColorGradient(ColorGradients.purpleBone);
        this.heatmap = new TaggedHeatMapPainter(axisZ);
        this.heatmap.setDiscardAbove(true);
        this.heatmap.setDiscardBelow(true);
        this.heatmap.setData(texture);
        this.heatmap.setColorScale(colors);
        plot.addPainter((GlimpsePainter)this.heatmap);
        plot.setColorScale(colors);
        plot.addPainter((GlimpsePainter)this.heatmap);
        CursorTextZPainter cursorPainter = new CursorTextZPainter();
        plot.addPainter((GlimpsePainter)cursorPainter);
        cursorPainter.setOffsetBySelectionSize(false);
        cursorPainter.setTexture(texture);
        return plot;
    }

    public GlimpsePainter getPainter() {
        return this.heatmap;
    }
}

