/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.basic;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener;
import com.metsci.glimpse.axis.painter.NumericAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.axis.tagged.TaggedAxisMouseListener1D;
import com.metsci.glimpse.axis.tagged.painter.TaggedPartialColorYAxisPainter;
import com.metsci.glimpse.axis.tagged.shader.TaggedPointShader;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer2D;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.gl.texture.FloatTexture1D;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.painter.shape.ShadedPointPainter;
import com.metsci.glimpse.plot.MultiAxisPlot2D;
import com.metsci.glimpse.support.colormap.ColorGradient;
import com.metsci.glimpse.support.colormap.ColorGradients;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Random;

public class ScatterplotExample
implements GlimpseLayoutProvider {
    public static int NUM_POINTS = 1000000;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new ScatterplotExample());
    }

    public MultiAxisPlot2D getLayout() {
        ShadedPointPainter painter;
        MultiAxisPlot2D plot = new MultiAxisPlot2D();
        plot.createAxisBottom("x_axis");
        plot.createAxisLeft("y_axis");
        plot.getAxis("x_axis").setParent(plot.getCenterAxisX());
        plot.getAxis("y_axis").setParent(plot.getCenterAxisY());
        plot.getAxis("x_axis").setMin(0.0);
        plot.getAxis("x_axis").setMax(4.0);
        plot.getAxis("y_axis").setMin(-200.0);
        plot.getAxis("y_axis").setMax(1000.0);
        plot.getAxis("x_axis").validate();
        plot.getAxis("y_axis").validate();
        TaggedAxis1D colorAxis = new TaggedAxis1D();
        TaggedAxisMouseListener1D colorMouseListener = new TaggedAxisMouseListener1D();
        MultiAxisPlot2D.AxisInfo colorAxisInfo = plot.createAxisRight("color_axis", (Axis1D)colorAxis, (AxisMouseListener)colorMouseListener);
        GridAxisLabelHandler colorTickHandler = new GridAxisLabelHandler();
        TaggedPartialColorYAxisPainter colorTagPainter = new TaggedPartialColorYAxisPainter((AxisLabelHandler)colorTickHandler);
        plot.getAxisInfo("color_axis").setAxisPainter((NumericAxisPainter)colorTagPainter);
        colorAxis.addTag("Tag1", 700.0).setAttribute("TexCoord", (Object)Float.valueOf(0.0f));
        colorAxis.addTag("Tag2", 4000.0).setAttribute("TexCoord", (Object)Float.valueOf(1.0f));
        colorAxis.setMin(-2000.0);
        colorAxis.setMax(6000.0);
        colorAxisInfo.getAxisPainter().setAxisLabel("Color Axis");
        colorAxisInfo.setSize(80);
        TaggedAxis1D sizeAxis = new TaggedAxis1D();
        TaggedAxisMouseListener1D sizeMouseListener = new TaggedAxisMouseListener1D();
        MultiAxisPlot2D.AxisInfo as = plot.createAxisRight("size_axis", (Axis1D)sizeAxis, (AxisMouseListener)sizeMouseListener);
        GridAxisLabelHandler sizeTickHandler = new GridAxisLabelHandler();
        TaggedPartialColorYAxisPainter sizeTagPainter = new TaggedPartialColorYAxisPainter((AxisLabelHandler)sizeTickHandler);
        plot.getAxisInfo("size_axis").setAxisPainter((NumericAxisPainter)sizeTagPainter);
        sizeAxis.addTag("Tag1", 0.2).setAttribute("TexCoord", (Object)Float.valueOf(0.0f));
        sizeAxis.addTag("Tag2", 0.8).setAttribute("TexCoord", (Object)Float.valueOf(1.0f));
        sizeAxis.setMin(0.0);
        sizeAxis.setMax(1.0);
        as.getAxisPainter().setAxisLabel("Size Axis");
        as.setSize(65);
        ColorTexture1D colorMapTexture = new ColorTexture1D(1024);
        colorMapTexture.setColorGradient(new ColorGradient(){

            public void toColor(float fraction, float[] rgba) {
                ColorGradients.bathymetry.toColor(fraction, rgba);
                rgba[3] = 0.6f;
            }
        });
        colorTagPainter.setColorScale(colorMapTexture);
        ColorTexture1D sizeTexture = new ColorTexture1D(1);
        sizeTexture.mutate(new ColorTexture1D.MutatorColor1D(){

            public void mutate(FloatBuffer floatBuffer, int dim) {
                floatBuffer.put(0.0f);
                floatBuffer.put(0.0f);
                floatBuffer.put(1.0f);
                floatBuffer.put(0.4f);
            }
        });
        sizeTagPainter.setColorScale(sizeTexture);
        FloatTexture1D sizeMapTexture = new FloatTexture1D(256);
        FloatTexture1D.MutatorFloat1D sizeMutator = new FloatTexture1D.MutatorFloat1D(){

            public void mutate(FloatBuffer data, int n0) {
                float minSize = 0.0f;
                float maxSize = 20.0f;
                float dSize = maxSize - minSize;
                data.clear();
                for (int i = 0; i < data.capacity(); ++i) {
                    float step = (float)i / (float)data.capacity();
                    float size = minSize + dSize * step * step;
                    data.put(size);
                }
            }
        };
        sizeMapTexture.mutate(sizeMutator);
        plot.addPainter((GlimpsePainter)new GridPainter((AxisLabelHandler)plot.getAxisInfo("x_axis").getTickHandler(), (AxisLabelHandler)plot.getAxisInfo("y_axis").getTickHandler()));
        try {
            painter = new ShadedPointPainter(plot.getAxis("color_axis"), plot.getAxis("size_axis")){

                protected void initShaderPipeline(Axis1D colorAxis, Axis1D sizeAxis) throws IOException {
                    this.vertShader = new TaggedPointShader(0, 1, this.colorAttributeIndex, this.sizeAttributeIndex, (TaggedAxis1D)colorAxis, (TaggedAxis1D)sizeAxis);
                    this.pipeline = new Pipeline("pointshader", null, (Shader)this.vertShader, null);
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        plot.addPainter((GlimpsePainter)painter);
        plot.addPainter((GlimpsePainter)new BorderPainter());
        final Random r = new Random();
        GLFloatBuffer2D xyValues = new GLFloatBuffer2D(NUM_POINTS);
        xyValues.mutate(new GLFloatBuffer.Mutator(){

            public void mutate(FloatBuffer data, int length) {
                data.clear();
                for (int i = 0; i < NUM_POINTS; ++i) {
                    float x = 6.0f * (float)i / (float)NUM_POINTS;
                    float y = (float)(Math.exp(x) * 10.0 + 15.0 + 20.0 * r.nextGaussian() * (double)x);
                    data.put(x);
                    data.put(y);
                }
            }
        });
        GLFloatBuffer colorValues = new GLFloatBuffer(NUM_POINTS, 1);
        colorValues.mutate(new GLFloatBuffer.Mutator(){

            public void mutate(FloatBuffer data, int length) {
                data.clear();
                for (int i = 0; i < NUM_POINTS; ++i) {
                    float x = 6.0f * (float)i / (float)NUM_POINTS;
                    float y = (float)(Math.exp(x) * 10.0 + r.nextDouble() * 500.0);
                    data.put((float)((double)x * ((double)y + r.nextDouble() * 500.0)));
                }
            }
        });
        GLFloatBuffer sizeValues = new GLFloatBuffer(NUM_POINTS, 1);
        sizeValues.mutate(new GLFloatBuffer.Mutator(){

            public void mutate(FloatBuffer data, int length) {
                data.clear();
                for (int i = 0; i < NUM_POINTS; ++i) {
                    data.put(r.nextFloat());
                }
            }
        });
        painter.useVertexPositionData(xyValues);
        painter.useColorAttribData(colorValues);
        painter.useSizeAttribData(sizeValues);
        painter.useColorScale(colorMapTexture);
        painter.useSizeScale(sizeMapTexture);
        painter.setDiscardAboveColor(true);
        painter.setDiscardBelowColor(true);
        return plot;
    }
}

