/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.basic;

import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener2D;
import com.metsci.glimpse.axis.painter.NumericAxisPainter;
import com.metsci.glimpse.axis.painter.NumericRightYAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.event.mouse.GlimpseMouseAllListener;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.LegendPainter;
import com.metsci.glimpse.painter.info.CursorTextPainter;
import com.metsci.glimpse.painter.plot.XYLinePainter;
import com.metsci.glimpse.plot.SimplePlot2D;
import com.metsci.glimpse.support.color.GlimpseColor;

public class LinePlotExample
implements GlimpseLayoutProvider {
    public static int NUM_POINTS = 100;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new LinePlotExample());
    }

    public SimplePlot2D getLayout() {
        SimplePlot2D plot = new SimplePlot2D(){

            protected NumericAxisPainter createAxisPainterZ(AxisLabelHandler tickHandler) {
                return new NumericRightYAxisPainter(tickHandler);
            }
        };
        GlimpseAxisLayout2D layout = new GlimpseAxisLayout2D(plot.getAxisX(), plot.getAxisZ());
        layout.setEventConsumer(false);
        plot.getLayoutCenter().addLayout((GlimpseLayout)layout);
        AxisMouseListener2D listener = new AxisMouseListener2D();
        layout.addGlimpseMouseAllListener((GlimpseMouseAllListener)listener);
        plot.setAxisSizeZ(40);
        plot.setBorderSize(15);
        plot.setAxisSizeY(40);
        plot.setTitle("Line Plot Example");
        plot.setAxisLabelX("x axis");
        plot.setAxisLabelY("data series 1");
        plot.setAxisLabelZ("data series 2");
        plot.setMinX(0.0);
        plot.setMaxX(100.0);
        plot.setMinY(0.0);
        plot.setMaxY(10.0);
        plot.getCrosshairPainter().showSelectionBox(false);
        XYLinePainter series1 = LinePlotExample.createXYLinePainter1();
        plot.addPainter((GlimpsePainter)series1);
        XYLinePainter series2 = LinePlotExample.createXYLinePainter2();
        layout.addPainter((GlimpsePainter)series2);
        CursorTextPainter cursorPainter = new CursorTextPainter();
        plot.addPainter((GlimpsePainter)cursorPainter);
        LegendPainter.LineLegendPainter legend = new LegendPainter.LineLegendPainter(LegendPainter.LegendPlacement.SE);
        legend.setOffsetY(10);
        legend.setOffsetX(100);
        legend.addItem("Series 1", GlimpseColor.fromColorRgba((float)1.0f, (float)0.0f, (float)0.0f, (float)0.8f));
        legend.addItem("Series 2", GlimpseColor.fromColorRgba((float)0.0f, (float)0.0f, (float)1.0f, (float)0.8f));
        legend.setLineStipple("Series 2", 1, (short)255);
        legend.setLegendItemWidth(60);
        plot.getLayoutCenter().addPainter((GlimpsePainter)legend);
        return plot;
    }

    public static XYLinePainter createXYLinePainter1() {
        float[] dataX = new float[NUM_POINTS];
        float[] dataY = new float[NUM_POINTS];
        XYLinePainter series1 = new XYLinePainter();
        LinePlotExample.generateData1(dataX, dataY, NUM_POINTS);
        series1.setData(dataX, dataY);
        series1.setLineColor(GlimpseColor.fromColorRgba((float)1.0f, (float)0.0f, (float)0.0f, (float)0.8f));
        series1.setLineThickness(0.5f);
        series1.showPoints(false);
        return series1;
    }

    public static XYLinePainter createXYLinePainter2() {
        float[] dataX = new float[NUM_POINTS];
        float[] dataY = new float[NUM_POINTS];
        XYLinePainter series2 = new XYLinePainter();
        LinePlotExample.generateData2(dataX, dataY, NUM_POINTS);
        series2.setData(dataX, dataY);
        series2.setLineColor(GlimpseColor.fromColorRgba((float)0.0f, (float)0.0f, (float)1.0f, (float)0.8f));
        series2.setLineThickness(1.5f);
        series2.showPoints(false);
        series2.setLineStipple(true);
        return series2;
    }

    public static void generateData1(float[] dataX, float[] dataY, int size) {
        for (int i = 0; i < size; ++i) {
            float x;
            dataX[i] = x = (float)i;
            dataY[i] = (float)(Math.random() * 0.4 - 0.2 + Math.sqrt(x));
        }
    }

    public static void generateData2(float[] dataX, float[] dataY, int size) {
        for (int i = 0; i < size; ++i) {
            float x;
            dataX[i] = x = (float)i;
            dataY[i] = (float)Math.sqrt(x);
        }
    }
}

