/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.basic;

import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.texture.ShadedTexturePainter;
import com.metsci.glimpse.plot.SimplePlot2D;
import com.metsci.glimpse.support.projection.FlatProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.texture.ColorTextureProjected2D;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.IOException;
import java.nio.FloatBuffer;

public class ImageExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new ImageExample());
    }

    public SimplePlot2D getLayout() {
        SimplePlot2D plot = new SimplePlot2D();
        plot.getCrosshairPainter().setVisible(false);
        plot.setBorderSize(10);
        plot.setAxisSizeX(0);
        plot.setAxisSizeY(0);
        plot.setTitleHeight(0);
        plot.setMinX(-10.0);
        plot.setMaxX(300.0);
        plot.setMinY(-50.0);
        plot.setMaxY(250.0);
        plot.lockAspectRatioXY(1.0);
        plot.setSelectionSize(100.0);
        ColorTextureProjected2D texture1 = new ColorTextureProjected2D(0, 0);
        try {
            texture1.setData(StreamOpener.fileThenResource.openForRead("images/GlimpseLogo.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        texture1.setProjection((Projection)new FlatProjection(0.0, (double)texture1.getDimensionSize(0), 0.0, (double)texture1.getDimensionSize(1)));
        ColorTextureProjected2D texture2 = new ColorTextureProjected2D(400, 400);
        texture2.mutate(new FloatTextureProjected2D.MutatorFloat2D(){

            public void mutate(FloatBuffer data, int dataSizeX, int dataSizeY) {
                for (int y = 0; y < dataSizeY; ++y) {
                    for (int x = 0; x < dataSizeX; ++x) {
                        data.put((float)((Math.random() * 100.0 + (double)(x * y)) / 176400.0));
                        data.put(0.2f);
                        data.put(0.3f + (float)y / (float)dataSizeY * 0.3f);
                        data.put(0.5f);
                    }
                }
            }
        });
        texture2.setProjection((Projection)new FlatProjection(-50.0, 350.0, -100.0, 300.0));
        ShadedTexturePainter imagePainter = new ShadedTexturePainter();
        imagePainter.addDrawableTexture((DrawableTexture)texture1);
        imagePainter.addDrawableTexture((DrawableTexture)texture2);
        plot.addPainter((GlimpsePainter)imagePainter);
        return plot;
    }
}

