/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.basic;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutManagerMig;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.plot.HistogramPainter;
import com.metsci.glimpse.painter.plot.StackedHistogramPainter;
import com.metsci.glimpse.plot.SimplePlot2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;

public class HistogramPlotExample
implements GlimpseLayoutProvider {
    public static int NUM_POINTS = 100000;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new HistogramPlotExample());
    }

    public GlimpseLayout getLayout() {
        float[] data1 = HistogramPlotExample.generateData1(new float[NUM_POINTS], NUM_POINTS);
        float[] data2 = HistogramPlotExample.generateData2(new float[NUM_POINTS], NUM_POINTS);
        float[] data3 = HistogramPlotExample.generateData3(new float[NUM_POINTS], NUM_POINTS);
        Axis1D xAxis = new Axis1D();
        xAxis.setMin(-10.0);
        xAxis.setMax(15.0);
        xAxis.setAbsoluteMin(-10.0);
        xAxis.setAbsoluteMax(15.0);
        GlimpseLayout histogramPlot1 = this.createDualHistograms(xAxis, data1, data2, data3);
        GlimpseLayout histogramPlot2 = this.createStackedHistograms(xAxis, data1, data2, data3);
        GlimpseLayout histogramPlot3 = this.createStackedScaledHistograms(xAxis, data1, data2, data3);
        GlimpseLayout layout = new GlimpseLayout();
        layout.addPainter((GlimpsePainter)new BackgroundPainter(true));
        ((GlimpseLayoutManagerMig)layout.getLayoutManager()).setLayoutConstraints("bottomtotop, gapx 0, gapy 0, insets 5 5 5 5");
        ((GlimpseLayoutManagerMig)layout.getLayoutManager()).setRowConstraints("[grow|grow|grow]");
        ((GlimpseLayoutManagerMig)layout.getLayoutManager()).setColumnConstraints("[grow]");
        layout.addLayout(histogramPlot1);
        histogramPlot1.setLayoutData((Object)"grow, wrap");
        layout.addLayout(histogramPlot2);
        histogramPlot2.setLayoutData((Object)"grow, wrap");
        layout.addLayout(histogramPlot3);
        histogramPlot3.setLayoutData((Object)"grow");
        layout.invalidateLayout();
        return layout;
    }

    GlimpseLayout createDualHistograms(Axis1D xAxis, float[] data1, float[] data2, float[] data3) {
        SimplePlot2D histogramplot = new SimplePlot2D();
        histogramplot.setTitle("Histogram Plot");
        histogramplot.setAxisLabelX("x axis");
        histogramplot.setAxisLabelY("frequency");
        histogramplot.getAxis().getAxisX().setParent(xAxis);
        histogramplot.setMinY(0.0);
        histogramplot.setMaxY(0.02);
        histogramplot.setAbsoluteMinY(0.0);
        histogramplot.setAbsoluteMaxY(1.0);
        histogramplot.lockMinY(0.0);
        histogramplot.getCrosshairPainter().showSelectionBox(false);
        histogramplot.setShowMinorTicksX(true);
        histogramplot.setShowMinorTicksY(true);
        HistogramPainter series1 = new HistogramPainter();
        HistogramPainter series2 = new HistogramPainter();
        HistogramPainter series3 = new HistogramPainter();
        series1.setData(data1);
        series1.setColor(GlimpseColor.fromColorRgba((float)1.0f, (float)0.0f, (float)0.0f, (float)0.6f));
        series2.setData(data2);
        series2.setColor(GlimpseColor.fromColorRgba((float)0.0f, (float)1.0f, (float)0.0f, (float)0.6f));
        series3.setData(data3);
        series3.setColor(GlimpseColor.fromColorRgba((float)0.0f, (float)0.0f, (float)1.0f, (float)0.6f));
        histogramplot.addPainter((GlimpsePainter)series1);
        histogramplot.addPainter((GlimpsePainter)series2);
        histogramplot.addPainter((GlimpsePainter)series3);
        return histogramplot;
    }

    GlimpseLayout createStackedHistograms(Axis1D xAxis, float[] data1, float[] data2, float[] data3) {
        SimplePlot2D histogramplot = new SimplePlot2D();
        histogramplot.setTitle("Stacked Histograms");
        histogramplot.setAxisLabelX("x axis");
        histogramplot.setAxisLabelY("frequency");
        histogramplot.getAxis().getAxisX().setParent(xAxis);
        histogramplot.lockMinY(0.0);
        histogramplot.setShowMinorTicksX(true);
        histogramplot.setShowMinorTicksY(true);
        histogramplot.getCrosshairPainter().showSelectionBox(false);
        StackedHistogramPainter stacked = new StackedHistogramPainter();
        stacked.setData((float[][])new float[][]{data1, data2, data3});
        stacked.setSeriesColor(0, GlimpseColor.fromColorRgba((float)1.0f, (float)0.0f, (float)0.0f, (float)0.6f));
        stacked.setSeriesColor(1, GlimpseColor.fromColorRgba((float)0.0f, (float)1.0f, (float)0.0f, (float)0.6f));
        stacked.setSeriesColor(2, GlimpseColor.fromColorRgba((float)0.0f, (float)0.0f, (float)1.0f, (float)0.6f));
        histogramplot.addPainter((GlimpsePainter)stacked);
        stacked.autoAdjustAxisBounds(histogramplot.getAxis());
        return histogramplot;
    }

    GlimpseLayout createStackedScaledHistograms(Axis1D xAxis, float[] data1, float[] data2, float[] data3) {
        SimplePlot2D histogramplot = new SimplePlot2D();
        histogramplot.setTitle("Stacked/Scaled Histograms");
        histogramplot.setAxisLabelX("x axis");
        histogramplot.setAxisLabelY("frequency");
        histogramplot.getAxis().getAxisX().setParent(xAxis);
        histogramplot.lockMinY(0.0);
        histogramplot.setShowMinorTicksX(true);
        histogramplot.setShowMinorTicksY(true);
        histogramplot.getCrosshairPainter().showSelectionBox(false);
        StackedHistogramPainter stacked = new StackedHistogramPainter(){
            Float2IntMap totalHeights;

            public void setData(int totalNumValues, float binSize, Float2IntMap ... counts) {
                this.totalHeights = new Float2IntOpenHashMap();
                this.totalHeights.defaultReturnValue(0);
                for (Float2IntMap countMap : counts) {
                    for (Float2IntMap.Entry entry : countMap.float2IntEntrySet()) {
                        int sum = this.totalHeights.get(entry.getFloatKey());
                        this.totalHeights.put(entry.getFloatKey(), sum += entry.getIntValue());
                    }
                }
                super.setData(totalNumValues, binSize, counts);
            }

            protected float getBarHeight(float bin, int count, int totalValues) {
                return (float)count / (float)this.totalHeights.get(bin);
            }
        };
        stacked.setData((float[][])new float[][]{data1, data2, data3});
        stacked.setSeriesColor(0, GlimpseColor.fromColorRgba((float)1.0f, (float)0.0f, (float)0.0f, (float)0.6f));
        stacked.setSeriesColor(1, GlimpseColor.fromColorRgba((float)0.0f, (float)1.0f, (float)0.0f, (float)0.6f));
        stacked.setSeriesColor(2, GlimpseColor.fromColorRgba((float)0.0f, (float)0.0f, (float)1.0f, (float)0.6f));
        histogramplot.addPainter((GlimpsePainter)stacked);
        stacked.autoAdjustAxisBounds(histogramplot.getAxis());
        return histogramplot;
    }

    public static float[] generateData1(float[] data, int size) {
        for (int i = 0; i < size; ++i) {
            data[i] = (float)(5.0 * Math.random() + 10.0 * Math.sin((double)i * 6.366197723675814));
        }
        return data;
    }

    public static float[] generateData2(float[] data, int size) {
        for (int i = 0; i < size; ++i) {
            data[i] = (float)(Math.pow(Math.random(), 3.0) * -20.0 + 10.0);
        }
        return data;
    }

    public static float[] generateData3(float[] data, int size) {
        for (int i = 0; i < size; ++i) {
            data[i] = (float)(Math.pow(35.0, Math.random()) - 10.0);
        }
        return data;
    }
}

