/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.basic;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.info.CursorTextZPainter;
import com.metsci.glimpse.painter.texture.HeatMapPainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.colormap.ColorGradients;
import com.metsci.glimpse.support.projection.FlatProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;

public class HeatMapExample
implements GlimpseLayoutProvider {
    protected HeatMapPainter heatmapPainter;
    protected CursorTextZPainter cursorPainter;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new HeatMapExample());
    }

    public ColorAxisPlot2D getLayout() {
        ColorAxisPlot2D plot = new ColorAxisPlot2D();
        plot.setTitle("Heat Map Example");
        plot.setAxisLabelX("x axis");
        plot.setAxisLabelY("y axis");
        plot.setBorderSize(30);
        plot.setAxisSizeX(40);
        plot.setAxisSizeY(60);
        plot.setMinX(0.0);
        plot.setMaxX(1000.0);
        plot.setMinY(0.0);
        plot.setMaxY(1000.0);
        plot.setMinZ(0.0);
        plot.setMaxZ(1000.0);
        plot.setAbsoluteMinY(0.0);
        plot.lockAspectRatioXY(1.0);
        plot.setSelectionSize(100.0);
        plot.setShowMinorTicks(true);
        plot.setMinorTickCount(9);
        this.heatmapPainter = HeatMapExample.newHeatMapPainter(plot.getAxisZ());
        plot.addPainter((GlimpsePainter)this.heatmapPainter);
        plot.setColorScale(this.heatmapPainter.getColorScale());
        this.cursorPainter = new CursorTextZPainter();
        plot.addPainterForeground((GlimpsePainter)this.cursorPainter);
        this.cursorPainter.setTexture(this.heatmapPainter.getData());
        return plot;
    }

    public CursorTextZPainter getCursorPainter() {
        return this.cursorPainter;
    }

    public HeatMapPainter getPainter() {
        return this.heatmapPainter;
    }

    public static double[][] generateData(int sizeX, int sizeY) {
        double[][] data = new double[sizeX][sizeY];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                data[x][y] = Math.random() * 100.0 + (double)(x * y) / 1000.0;
            }
        }
        return data;
    }

    public static ColorTexture1D newColorTexture() {
        ColorTexture1D colors = new ColorTexture1D(1024);
        colors.setColorGradient(ColorGradients.jet);
        return colors;
    }

    public static HeatMapPainter newHeatMapPainter(Axis1D axis) {
        return HeatMapExample.newHeatMapPainter(HeatMapExample.newColorTexture(), axis);
    }

    public static HeatMapPainter newHeatMapPainter(ColorTexture1D colorScale, Axis1D axis) {
        double[][] data = HeatMapExample.generateData(1000, 1000);
        FlatProjection projection = new FlatProjection(0.0, 1000.0, 0.0, 1000.0);
        FloatTextureProjected2D texture = new FloatTextureProjected2D(1000, 1000);
        texture.setProjection((Projection)projection);
        texture.setData(data);
        HeatMapPainter heatmapPainter = new HeatMapPainter(axis);
        heatmapPainter.setData(texture);
        heatmapPainter.setColorScale(colorScale);
        return heatmapPainter;
    }
}

