/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.basic;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.AxisUtil;
import com.metsci.glimpse.axis.listener.AxisListener2D;
import com.metsci.glimpse.axis.listener.RateLimitedAxisListener2D;
import com.metsci.glimpse.axis.painter.NumericXYAxisPainter;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.painter.shape.LineSetPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.util.math.fast.FastGaussian;

public class FunctionPlotExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new FunctionPlotExample());
    }

    public GlimpseLayout getLayout() {
        GlimpseAxisLayout2D layout = new GlimpseAxisLayout2D();
        Axis2D axis = AxisUtil.createAxis2D((GlimpseAxisLayout2D)layout);
        axis.getAxisX().setMin(-2.0);
        axis.getAxisX().setMax(8.0);
        axis.getAxisY().setMin(-2.0);
        axis.getAxisY().setMax(8.0);
        axis.lockAspectRatioXY(1.0);
        BackgroundPainter backgroundPainter = new BackgroundPainter(false);
        layout.addPainter((GlimpsePainter)backgroundPainter);
        GridPainter gridPainter = new GridPainter();
        layout.addPainter((GlimpsePainter)gridPainter);
        NumericXYAxisPainter axisPainter = new NumericXYAxisPainter();
        layout.addPainter((GlimpsePainter)axisPainter);
        Function1D f1 = new Function1D(){
            final FastGaussian f = new FastGaussian(1000000);

            @Override
            public double f(double x) {
                return this.f.evaluate(x) * 5.0;
            }
        };
        Function1D f2 = new Function1D(){

            @Override
            public double f(double x) {
                return Math.sin(x);
            }
        };
        Function1DPainter functionPainter1 = new Function1DPainter(axis, f1);
        functionPainter1.setLineColor(GlimpseColor.getBlue());
        functionPainter1.setLineWidth(2.5f);
        layout.addPainter((GlimpsePainter)functionPainter1);
        Function1DPainter functionPainter2 = new Function1DPainter(axis, f2);
        functionPainter2.setLineColor(GlimpseColor.getRed());
        functionPainter2.setLineWidth(2.5f);
        layout.addPainter((GlimpsePainter)functionPainter2);
        return layout;
    }

    public static interface Function1D {
        public double f(double var1);
    }

    public static class Function1DPainter
    extends LineSetPainter {
        private static final double PAN_BUFFER = 0.8;
        private static final double ZOOM_BUFFER = 0.5;
        private static final int X_POINTS = 300;
        private double currentMin;
        private double currentMax;
        private double currentDiff;
        private float[] dataX = new float[300];
        private float[] dataY = new float[300];

        public Function1DPainter(Axis2D axis, final Function1D function) {
            axis.addAxisListener((AxisListener2D)new RateLimitedAxisListener2D(){

                public void axisUpdatedRateLimited(Axis2D axis) {
                    double min = axis.getAxisX().getMin();
                    double max = axis.getAxisX().getMax();
                    double diff = max - min;
                    if (min < Function1DPainter.this.currentMin || max > Function1DPainter.this.currentMax || diff < Function1DPainter.this.currentDiff * 0.5) {
                        this.recalculate(min, max);
                    }
                }

                protected void recalculate(double min, double max) {
                    double buffer = (max - min) * 0.8;
                    Function1DPainter.this.currentMin = min - buffer;
                    Function1DPainter.this.currentMax = max + buffer;
                    Function1DPainter.this.currentDiff = Function1DPainter.this.currentMax - Function1DPainter.this.currentMin;
                    double step = Function1DPainter.this.currentDiff / 300.0;
                    double x = Function1DPainter.this.currentMin;
                    int i = 0;
                    while (i < 300) {
                        ((Function1DPainter)Function1DPainter.this).dataX[i] = (float)x;
                        ((Function1DPainter)Function1DPainter.this).dataY[i] = (float)function.f(x);
                        ++i;
                        x += step;
                    }
                    Function1DPainter.this.setData(Function1DPainter.this.dataX, Function1DPainter.this.dataY);
                }
            });
        }
    }
}

