/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.axis;

import com.metsci.glimpse.axis.UpdateMode;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.basic.HeatMapExample;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.texture.HeatMapPainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.colormap.ColorGradient;
import com.metsci.glimpse.support.colormap.ColorGradients;
import com.metsci.glimpse.support.projection.FlatProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;

public class LinkedHeatMapExample {
    protected ColorAxisPlot2D leftPlot;
    protected ColorAxisPlot2D rightPlot;
    protected FloatTextureProjected2D texture;

    public static void main(String[] args) throws Exception {
        final LinkedHeatMapExample example = new LinkedHeatMapExample();
        Example.showWithSwing(new GlimpseLayoutProvider(){

            public GlimpseLayout getLayout() {
                return example.getLayoutLeft();
            }
        }, new GlimpseLayoutProvider(){

            public GlimpseLayout getLayout() {
                return example.getLayoutRight();
            }
        });
    }

    public ColorAxisPlot2D getLayoutLeft() {
        if (this.leftPlot == null) {
            this.buildLayouts();
        }
        return this.leftPlot;
    }

    public ColorAxisPlot2D getLayoutRight() {
        if (this.rightPlot == null) {
            this.buildLayouts();
        }
        return this.rightPlot;
    }

    protected void buildLayouts() {
        this.leftPlot = this.createPlot2D(ColorGradients.reverseBone);
        this.rightPlot = this.createPlot2D(ColorGradients.jet);
        this.rightPlot.getAxis().setParent(this.leftPlot.getAxis());
    }

    public ColorAxisPlot2D createPlot2D(ColorGradient gradient) {
        ColorAxisPlot2D plot = new ColorAxisPlot2D();
        plot.setTitle("Linked Heat Map Example");
        plot.setAxisLabelX("x axis");
        plot.setAxisLabelY("y axis");
        plot.setUpdateModeXY(UpdateMode.CenterScale);
        plot.setMinX(0.0);
        plot.setMaxX(1000.0);
        plot.setMinY(0.0);
        plot.setMaxY(1000.0);
        plot.setMinZ(0.0);
        plot.setMaxZ(1000.0);
        plot.setAbsoluteMinZ(-1000.0);
        plot.setAbsoluteMaxZ(2000.0);
        plot.lockAspectRatioXY(1.0);
        plot.setSelectionSize(100.0);
        ColorTexture1D colorScale = new ColorTexture1D(1024);
        colorScale.setColorGradient(gradient);
        plot.setColorScale(colorScale);
        HeatMapPainter painter = new HeatMapPainter(plot.getAxisZ());
        painter.setColorScale(colorScale);
        if (this.texture == null) {
            this.texture = LinkedHeatMapExample.createTextureData();
        }
        painter.setData(this.texture);
        plot.setColorScale(colorScale);
        plot.addPainter((GlimpsePainter)painter);
        return plot;
    }

    protected static FloatTextureProjected2D createTextureData() {
        FlatProjection projection = new FlatProjection(0.0, 1000.0, 0.0, 1000.0);
        FloatTextureProjected2D texture = new FloatTextureProjected2D(1000, 1000);
        texture.setProjection((Projection)projection);
        texture.setData(HeatMapExample.generateData(1000, 1000));
        return texture;
    }
}

