/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.animated;

import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.metsci.glimpse.gl.texture.FloatTexture2D;
import com.metsci.glimpse.gl.texture.Texture;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.info.FpsPainter;
import com.metsci.glimpse.painter.texture.ShadedTexturePainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.colormap.ColorGradients;
import com.metsci.glimpse.support.shader.SampledColorScaleShader;
import java.io.IOException;
import java.nio.FloatBuffer;

public class AnimatedTextureExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new AnimatedTextureExample());
    }

    public ColorAxisPlot2D getLayout() {
        SampledColorScaleShader shader;
        ColorAxisPlot2D plot = new ColorAxisPlot2D();
        plot.setPlotBackgroundColor(GlimpseColor.getBlack());
        plot.setBackgroundColor(GlimpseColor.getBlack());
        plot.setAxisColor(GlimpseColor.getWhite());
        plot.getGridPainter().setLineColor(GlimpseColor.getWhite((float)0.5f));
        plot.setAxisLabelX("x axis");
        plot.setAxisLabelY("y axis");
        plot.setAxisLabelZ("z axis");
        plot.setTitle("Animated Texture");
        plot.setTitleColor(GlimpseColor.getWhite());
        plot.getCrosshairPainter().setCursorColor(GlimpseColor.getGreen((float)0.2f));
        plot.getCrosshairPainter().setShadeColor(GlimpseColor.getGreen((float)0.05f));
        plot.getCrosshairPainter().setShadeSelectionBox(true);
        plot.getCrosshairPainter().setLineWidth(1.0f);
        plot.setMinX(-1.2);
        plot.setMaxX(1.2);
        plot.setMinY(-1.2);
        plot.setMaxY(1.2);
        plot.setMinZ(0.0);
        plot.setMaxZ(1000.0);
        plot.lockAspectRatioXY(1.0);
        final ShadedTexturePainter painter = new ShadedTexturePainter();
        plot.addPainter((GlimpsePainter)painter);
        ColorTexture1D colors = new ColorTexture1D(1024);
        colors.setColorGradient(ColorGradients.jet);
        boolean dataTextureUnit = false;
        boolean colorScaleTextureUnit = true;
        painter.addNonDrawableTexture((Texture)colors, 1);
        try {
            shader = new SampledColorScaleShader(plot.getAxisZ(), 0, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        painter.setPipeline(new Pipeline("colormap", null, null, (Shader)shader));
        new Thread(new Runnable(){

            @Override
            public void run() {
                FloatTexture2D data = AnimatedTextureExample.setupTexture();
                FloatTexture2D.MutatorFloat2D mutator = AnimatedTextureExample.setupMutator(data);
                painter.addDrawableTexture((DrawableTexture)data, 0);
                while (true) {
                    data.mutate(mutator);
                    try {
                        Thread.sleep(40L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }).start();
        plot.setColorScale(colors);
        plot.addPainter((GlimpsePainter)new BorderPainter());
        plot.addPainter((GlimpsePainter)new FpsPainter());
        return plot;
    }

    static FloatTexture2D setupTexture() {
        int n = 200;
        double[] min = new double[]{-1.0, -1.0};
        double[] max = new double[]{1.0, 1.0};
        FloatTexture2D data = new FloatTexture2D(min, max, n, n, false);
        return data;
    }

    static FloatTexture2D.MutatorFloat2D setupMutator(FloatTexture2D data) {
        FloatTexture2D.MutatorFloat2D editor = new FloatTexture2D.MutatorFloat2D(){
            double w = 0.10471975511965977;
            int fr = 0;

            public void mutate(FloatBuffer data, double[] min, double[] max, int[] dim) {
                data.clear();
                for (int i = 0; i < dim[0]; ++i) {
                    for (int j = 0; j < dim[1]; ++j) {
                        double x0 = Math.PI * 2 * (double)i / (double)dim[0];
                        double x1 = Math.PI * 2 * (double)j / (double)dim[1];
                        data.put((float)(1000.0 * (Math.abs(Math.sin(x0 + this.w * (double)this.fr)) * (Math.sin(x0 - this.w * (double)this.fr) * Math.sin(8.0 * x0 + this.w * (double)this.fr) * Math.cos(-8.0 * x1 - this.w * (double)this.fr) + Math.abs(Math.sin(24.0 * x1)) / 3.0))));
                    }
                }
                ++this.fr;
            }
        };
        return editor;
    }
}

