/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.animated;

import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.examples.basic.HeatMapExample;
import com.metsci.glimpse.gl.texture.ColorTexture1D;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.info.CursorTextZPainter;
import com.metsci.glimpse.painter.info.FpsPainter;
import com.metsci.glimpse.painter.texture.HeatMapPainter;
import com.metsci.glimpse.plot.ColorAxisPlot2D;
import com.metsci.glimpse.support.colormap.ColorGradients;
import com.metsci.glimpse.support.projection.PolarProjection;
import com.metsci.glimpse.support.projection.Projection;
import com.metsci.glimpse.support.texture.FloatTextureProjected2D;

public class AnimatedProjectionExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new AnimatedProjectionExample());
    }

    public ColorAxisPlot2D getLayout() {
        ColorAxisPlot2D plot = new ColorAxisPlot2D();
        plot.setTitleHeight(0);
        plot.setAxisLabelX("x axis");
        plot.setAxisLabelY("y axis");
        plot.setAxisLabelZ("z axis");
        plot.setMinX(-1000.0);
        plot.setMaxX(1000.0);
        plot.setMinY(-1000.0);
        plot.setMaxY(1000.0);
        plot.setMinZ(0.0);
        plot.setMaxZ(1000.0);
        plot.lockAspectRatioXY(1.0);
        HeatMapPainter painter = new HeatMapPainter(plot.getAxisZ());
        plot.addPainter((GlimpsePainter)painter);
        ColorTexture1D colors = new ColorTexture1D(1024);
        colors.setColorGradient(ColorGradients.jet);
        PolarProjection projection = new PolarProjection(300.0, 1000.0, 0.0, 360.0);
        final FloatTextureProjected2D texture = new FloatTextureProjected2D(4000, 1000);
        double[][] data = HeatMapExample.generateData(4000, 1000);
        texture.setProjection((Projection)projection);
        texture.setData(data);
        painter.setColorScale(colors);
        painter.setData(texture);
        CursorTextZPainter cursorPainter = new CursorTextZPainter();
        plot.addPainter((GlimpsePainter)cursorPainter);
        cursorPainter.setTexture(texture);
        plot.setColorScale(colors);
        plot.addPainter((GlimpsePainter)new FpsPainter());
        new Thread(new Runnable(){

            @Override
            public void run() {
                double startT = 0.0;
                int endR = 1000;
                int dirR = 1;
                while (true) {
                    if ((startT += 0.1) > 360.0) {
                        startT = 0.0;
                    }
                    if (endR == 1000) {
                        dirR = -1;
                    }
                    if (endR == 500) {
                        dirR = 1;
                    }
                    PolarProjection newProjection = new PolarProjection(300.0, (double)(endR += dirR), startT, startT + 360.0);
                    texture.setProjection((Projection)newProjection);
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                    }
                }
            }
        }).start();
        return plot;
    }
}

