/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.animated;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.listener.RateLimitedAxisListener1D;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.CopyrightPainter;
import com.metsci.glimpse.painter.info.FpsPainter;
import com.metsci.glimpse.painter.shape.PolygonPainter;
import com.metsci.glimpse.plot.SimplePlot2D;
import com.metsci.glimpse.support.colormap.ColorGradient;
import com.metsci.glimpse.support.colormap.ColorGradients;
import java.util.Random;

public class AnimatedPolygonExample
implements GlimpseLayoutProvider {
    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new AnimatedPolygonExample());
    }

    public SimplePlot2D getLayout() {
        int i;
        SimplePlot2D polyplot = new SimplePlot2D();
        polyplot.setTitle("Polygon Example");
        polyplot.setAxisLabelX("easting", "meters", false);
        polyplot.setAxisLabelY("northing", "meters", false);
        polyplot.setAxisLabelZ("time", "hours");
        polyplot.setAxisSizeZ(65);
        polyplot.setMinX(-20.0);
        polyplot.setMaxX(20.0);
        polyplot.setMinY(-20.0);
        polyplot.setMaxY(20.0);
        polyplot.setMinZ(0.0);
        polyplot.setMaxZ(1000.0);
        polyplot.lockAspectRatioXY(1.0);
        polyplot.setSelectionSize(50000.0);
        polyplot.addPainter((GlimpsePainter)new CopyrightPainter());
        polyplot.addPainter((GlimpsePainter)new FpsPainter());
        final PolygonPainter polygonPainter = new PolygonPainter();
        polyplot.addPainter((GlimpsePainter)polygonPainter);
        for (i = 0; i < 100; ++i) {
            polygonPainter.addPolygon(1, i, (long)i, (long)i, new float[]{0.0f, i, i, 0.0f}, new float[]{0.0f, 0.0f, i, i}, (float)i);
        }
        for (i = 0; i < 100; ++i) {
            polygonPainter.addPolygon(2, i, (long)i, (long)i, new float[]{0.0f, -i, -i, 0.0f}, new float[]{0.0f, 0.0f, -i, -i}, (float)(i + 100));
        }
        polygonPainter.addPolygon(4, 1, new float[]{-10.0f, 0.0f, 10.0f, 10.0f, 0.0f}, new float[]{-10.0f, 8.0f, 0.0f, 10.0f, 10.0f}, 200.0f);
        polygonPainter.setLineWidth(1, 3.0f);
        polygonPainter.setLineColor(2, 0.0f, 0.0f, 1.0f, 1.0f);
        polygonPainter.setLineDotted(2, true);
        polygonPainter.setFill(3, true);
        polygonPainter.setLineWidth(3, 3.0f);
        polygonPainter.setFillColor(3, 0.0f, 1.0f, 0.0f, 1.0f);
        polygonPainter.setFill(4, true);
        polygonPainter.setLineColor(6, 1.0f, 0.0f, 0.0f, 1.0f);
        polygonPainter.setFill(6, false);
        polygonPainter.setPolyDotted(4, true);
        polygonPainter.setPolyDotted(3, true);
        new Thread(){

            @Override
            public void run() {
                int i = 0;
                while (true) {
                    polygonPainter.addPolygon(6, i, (long)i, (long)(i + 20), new float[]{0.0f, -i, -i, 0.0f}, new float[]{0.0f, 0.0f, i, i}, 100.0f);
                    int deleteId = (int)(Math.random() * (double)i);
                    polygonPainter.deletePolygon(6, deleteId);
                    ++i;
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
        new Thread(){
            int i = 5;
            ColorGradient c = ColorGradients.jet;
            float[] rgba = new float[4];
            Random r = new Random();

            @Override
            public void run() {
                while (true) {
                    float x0 = 200.0f * this.r.nextFloat();
                    float y0 = 200.0f * this.r.nextFloat();
                    float t = (float)((double)this.r.nextFloat() * Math.PI * 2.0);
                    float d = 15.0f;
                    float dt = 0.08726646f;
                    float x1 = (float)((double)x0 + (double)d * Math.sin(t - dt));
                    float y1 = (float)((double)y0 + (double)d * Math.cos(t - dt));
                    float x2 = (float)((double)x0 + (double)d * Math.sin(t + dt));
                    float y2 = (float)((double)y0 + (double)d * Math.cos(t + dt));
                    if (this.i % 2 == 0) {
                        polygonPainter.addPolygon(5, this.i, (long)this.i, (long)(this.i + 1000), new float[]{x0, x1, x2}, new float[]{y0, y1, y2}, (float)(200 + this.i));
                    } else {
                        polygonPainter.addPolygon(5 + this.i, 0, (long)this.i, (long)(this.i + 1000), new float[]{x0, x1, x2}, new float[]{y0, y1, y2}, (float)(200 + this.i));
                    }
                    polygonPainter.setFill(5 + this.i, true);
                    polygonPainter.setShowLines(5 + this.i, false);
                    this.c.toColor((float)(this.i % 50) / 50.0f, this.rgba);
                    polygonPainter.setFillColor(5 + this.i, this.rgba[0], this.rgba[1], this.rgba[2], this.r.nextFloat());
                    polygonPainter.setFillColor(5, this.rgba[0], this.rgba[1], this.rgba[2], 0.2f);
                    polygonPainter.setLineColor(5, this.rgba[0], this.rgba[1], this.rgba[2], 1.0f);
                    ++this.i;
                    try {
                        if (this.i < 2000) {
                            Thread.sleep(1L);
                            continue;
                        }
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
        polyplot.getAxisZ().addAxisListener((AxisListener1D)new RateLimitedAxisListener1D(){
            double prevMinTime = -1.0;
            double prevMaxTime = -1.0;

            public void axisUpdatedRateLimited(Axis1D handler) {
                double minTime = handler.getMin();
                double maxTime = handler.getMax();
                if (this.prevMinTime != minTime || this.prevMaxTime != maxTime) {
                    polygonPainter.displayTimeRange(minTime, maxTime);
                    this.prevMinTime = minTime;
                    this.prevMaxTime = maxTime;
                }
            }
        });
        return polyplot;
    }
}

