/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples.animated;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.listener.RateLimitedAxisListener1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseMotionListener;
import com.metsci.glimpse.examples.Example;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.info.CursorTextPainter;
import com.metsci.glimpse.painter.track.Point;
import com.metsci.glimpse.painter.track.Pulsator;
import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.plot.SimplePlot2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.selection.SpatialSelectionListener;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnimatedGeoPlotExample
implements GlimpseLayoutProvider {
    public static final int NUMBER_OF_TRACKS = 2000;

    public static void main(String[] args) throws Exception {
        Example.showWithSwing(new AnimatedGeoPlotExample());
    }

    public GlimpseLayout getLayout() {
        SimplePlot2D plot = new SimplePlot2D();
        plot.setAxisSizeZ(50);
        plot.setAxisSizeX(0);
        plot.setAxisSizeY(0);
        plot.setTitleHeight(0);
        plot.setAxisLabelZ("time", "hours", false);
        plot.setMinX(-20.0);
        plot.setMaxX(20.0);
        plot.setMinY(-20.0);
        plot.setMaxY(20.0);
        plot.setMinZ(0.0);
        plot.setMaxZ(1000.0);
        plot.setAxisSizeZ(65);
        plot.getAxisX().setSelectionCenter(10.0);
        plot.getAxisY().setSelectionCenter(10.0);
        plot.lockAspectRatioXY(1.0);
        plot.setSelectionSize(5.0);
        plot.setShowMinorTicksX(true);
        plot.setShowMinorTicksY(true);
        plot.setShowMinorTicksZ(true);
        final TrackPainter trackPainter = new TrackPainter(true);
        plot.addPainter((GlimpsePainter)trackPainter);
        TrackManager trackManager = new TrackManager(trackPainter, 2000);
        plot.getAxisZ().addAxisListener((AxisListener1D)new TimeAxisListener(trackPainter));
        plot.getAxisPainterZ().setShowMarker(true);
        trackManager.start();
        trackPainter.addSpatialSelectionListener(plot.getAxis(), (SpatialSelectionListener)new TrackSelectionListener(trackManager, trackPainter));
        final TrackPainter selectionDotPainter = new TrackPainter(false);
        plot.addPainter((GlimpsePainter)selectionDotPainter);
        selectionDotPainter.setShowPoints(0, true);
        selectionDotPainter.setPointSize(0, 10.0f);
        selectionDotPainter.setPointColor(0, GlimpseColor.getYellow());
        final CustomCursorTextPainter cursorText = new CustomCursorTextPainter();
        plot.addPainter((GlimpsePainter)cursorText);
        final Pulsator pulsator = new Pulsator(selectionDotPainter);
        pulsator.addId(0);
        pulsator.start();
        plot.addGlimpseMouseMotionListener(new GlimpseMouseMotionListener(){

            public void mouseMoved(GlimpseMouseEvent e) {
                Point point = trackPainter.getNearestPoint(e, 20);
                cursorText.setPoint(point);
                selectionDotPainter.clearTrack(0);
                pulsator.resetSize();
                if (point != null) {
                    selectionDotPainter.addPoint(0, 0, (double)point.getX(), (double)point.getY(), point.getTime());
                }
            }
        });
        return plot;
    }

    private static class Track {
        public static double TWO_PI = Math.PI * 2;
        public static double CHANGE_SCALE = TWO_PI / 20.0;
        private int pointId;
        private int trackId;
        private double y;
        private double x;
        private double direction;
        private double speed;
        private float r;
        private float g;
        private float b;

        public Track(int _trackId, float r, float g, float b) {
            this.trackId = _trackId;
            this.pointId = 0;
            this.y = Math.random() * 10.0;
            this.x = Math.random() * 10.0;
            this.speed = 0.1;
            this.direction = Math.random() * TWO_PI;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public void tick() {
            this.direction = this.direction + Math.random() * CHANGE_SCALE - CHANGE_SCALE / 2.0;
            this.x += Math.cos(this.direction) * this.speed;
            this.y += Math.sin(this.direction) * this.speed;
        }

        public void setColor(TrackPainter trackPainter) {
            trackPainter.setLineColor(this.trackId, this.r, this.g, this.b, 0.6f);
            trackPainter.setPointColor(this.trackId, this.r, this.g, this.b, 0.6f);
        }

        public void addPoint(TrackPainter trackPainter, long time) {
            trackPainter.addPoint(this.trackId, this.pointId++, this.x, this.y, time);
        }
    }

    private static class TrackManager
    extends Thread {
        private int time = 0;
        private Map<Integer, Track> tracks;
        private TrackPainter trackPainter;
        private int numberOfTracks;

        public TrackManager(TrackPainter trackPainter, int numberOfTracks) {
            this.trackPainter = trackPainter;
            this.numberOfTracks = numberOfTracks;
            this.tracks = Collections.synchronizedMap(new HashMap(numberOfTracks));
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numberOfTracks; ++i) {
                float r = (float)(Math.random() * 0.2 + 0.7);
                float g = (float)(Math.random() * 0.2 + 0.3);
                float b = (float)(Math.random() * 0.2 + 0.3);
                Track track = new Track(i, r, g, b);
                this.tracks.put(i, track);
                track.setColor(this.trackPainter);
                this.trackPainter.setPointSize(i, 0.5f);
                this.trackPainter.setLineWidth(i, 2.0f);
                this.trackPainter.setLabel(i, "Track " + i);
                this.trackPainter.setLabelColor(i, GlimpseColor.getBlack());
                this.trackPainter.setShowLabel(i, false);
                this.trackPainter.setShowLabelLine(i, false);
                this.trackPainter.setHeadPointSize(i, 4.0f);
                this.trackPainter.setShowHeadPoint(i, true);
            }
            while (true) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        TrackManager.this.time = TrackManager.this.time + 1;
                        for (Track track : TrackManager.this.tracks.values()) {
                            track.tick();
                            track.addPoint(TrackManager.this.trackPainter, TrackManager.this.time);
                        }
                    }
                };
                r.run();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public Track getTrack(int id) {
            return this.tracks.get(id);
        }
    }

    private static class TrackSelectionListener
    implements SpatialSelectionListener<Point> {
        private IntAVLTreeSet selectedTrackIds = new IntAVLTreeSet();
        private IntAVLTreeSet newSelectedTrackIds = new IntAVLTreeSet();
        private TrackPainter trackPainter;
        private TrackManager trackManager;

        public TrackSelectionListener(TrackManager trackManager, TrackPainter trackPainter) {
            this.trackManager = trackManager;
            this.trackPainter = trackPainter;
        }

        public void selectionChanged(Collection<Point> newSelectedPoints) {
            this.newSelectedTrackIds.clear();
            for (Point p : newSelectedPoints) {
                this.newSelectedTrackIds.add(p.getTrackId());
            }
            IntBidirectionalIterator iter = this.newSelectedTrackIds.iterator();
            while (iter.hasNext()) {
                int trackId = iter.nextInt();
                this.trackPainter.setPointColor(trackId, 0.0f, 1.0f, 0.0f, 1.0f);
                this.trackPainter.setLineColor(trackId, 0.0f, 1.0f, 0.0f, 1.0f);
                this.trackPainter.setShowLabel(trackId, true);
                this.trackPainter.setHeadPointSize(trackId, 8.0f);
            }
            iter = this.selectedTrackIds.iterator();
            while (iter.hasNext()) {
                int trackId = iter.nextInt();
                if (this.newSelectedTrackIds.contains(trackId)) continue;
                Track track = this.trackManager.getTrack(trackId);
                if (track != null) {
                    track.setColor(this.trackPainter);
                }
                this.trackPainter.setShowLabel(trackId, false);
                this.trackPainter.setHeadPointSize(trackId, 4.0f);
            }
            IntAVLTreeSet temp = this.selectedTrackIds;
            this.selectedTrackIds = this.newSelectedTrackIds;
            this.newSelectedTrackIds = temp;
        }
    }

    private static class TimeAxisListener
    extends RateLimitedAxisListener1D {
        private long prevMinTime = -1L;
        private long prevMaxTime = -1L;
        private long prevSelectedTime = -1L;
        private TrackPainter trackPainter;

        public TimeAxisListener(TrackPainter trackPainter) {
            this.trackPainter = trackPainter;
        }

        public void axisUpdatedRateLimited(Axis1D axis) {
            long minTime = (long)axis.getMin();
            long maxTime = (long)axis.getMax();
            long selectedTime = (long)axis.getSelectionCenter();
            if (this.prevMinTime != minTime || this.prevMaxTime != maxTime || this.prevSelectedTime != selectedTime) {
                this.trackPainter.displayTimeRange(minTime, maxTime, selectedTime);
                this.prevMinTime = minTime;
                this.prevMaxTime = maxTime;
                this.prevSelectedTime = selectedTime;
            }
        }
    }

    private static class CustomCursorTextPainter
    extends CursorTextPainter {
        protected Point point;

        private CustomCursorTextPainter() {
        }

        public void setPoint(Point point) {
            this.point = point;
        }

        public String getTextX(Axis2D axis) {
            Point temp = this.point;
            if (temp != null) {
                return String.format("Track: %d Point: %d", temp.getTrackId(), temp.getPointId());
            }
            return "Id: (none)";
        }

        public String getTextY(Axis2D axis) {
            Point temp = this.point;
            if (temp != null) {
                return String.format("(%.2f, %.2f)", Float.valueOf(temp.getX()), Float.valueOf(temp.getY()));
            }
            return "";
        }
    }
}

