/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.examples;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.canvas.SwingGlimpseCanvas;
import com.metsci.glimpse.gl.Jogular;
import com.metsci.glimpse.gl.util.GLPBufferUtils;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutProvider;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.repaint.SwingRepaintManager;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.support.settings.SwingLookAndFeel;
import java.awt.Component;
import javax.media.opengl.GLContext;
import javax.swing.JFrame;

public class Example {
    private SwingGlimpseCanvas canvas;
    private RepaintManager manager;
    private JFrame frame;
    private GlimpseLayout layout;

    public Example(SwingGlimpseCanvas canvas, RepaintManager manager, JFrame frame, GlimpseLayout layout) {
        this.canvas = canvas;
        this.manager = manager;
        this.frame = frame;
        this.layout = layout;
    }

    public SwingGlimpseCanvas getCanvas() {
        return this.canvas;
    }

    public RepaintManager getManager() {
        return this.manager;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public GlimpseLayout getLayout() {
        return this.layout;
    }

    public static Example showWithSwing(GlimpseLayoutProvider layoutProvider) throws Exception {
        Jogular.initJogl();
        GLContext context = GLPBufferUtils.createPixelBuffer((int)1, (int)1).getContext();
        final SwingGlimpseCanvas canvas = new SwingGlimpseCanvas(true, context);
        GlimpseLayout layout = layoutProvider.getLayout();
        canvas.addLayout(layout);
        canvas.setLookAndFeel((LookAndFeel)new SwingLookAndFeel());
        SwingRepaintManager manager = SwingRepaintManager.newRepaintManager((GlimpseCanvas)canvas);
        JFrame frame = new JFrame("Glimpse Example");
        frame.add((Component)canvas);
        frame.pack();
        frame.setSize(800, 800);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        Runtime.getRuntime().addShutdownHook(new Thread((RepaintManager)manager){
            final /* synthetic */ RepaintManager val$manager;
            {
                this.val$manager = repaintManager;
            }

            @Override
            public void run() {
                canvas.dispose(this.val$manager);
            }
        });
        return new Example(canvas, (RepaintManager)manager, frame, layout);
    }

    public static void showWithSwing(GlimpseLayoutProvider layoutProviderA, GlimpseLayoutProvider layoutProviderB) throws Exception {
        Jogular.initJogl();
        SwingGlimpseCanvas leftPanel = new SwingGlimpseCanvas(true);
        leftPanel.addLayout(layoutProviderA.getLayout());
        SwingGlimpseCanvas rightPanel = new SwingGlimpseCanvas(true, leftPanel.getGLContext());
        rightPanel.addLayout(layoutProviderB.getLayout());
        SwingRepaintManager repaintManager = new SwingRepaintManager();
        repaintManager.addGlimpseCanvas((GlimpseCanvas)leftPanel);
        repaintManager.addGlimpseCanvas((GlimpseCanvas)rightPanel);
        repaintManager.start();
        JFrame rightFrame = new JFrame("Glimpse Example (Frame A)");
        rightFrame.add((Component)rightPanel);
        rightFrame.pack();
        rightFrame.setSize(800, 800);
        rightFrame.setLocation(800, 0);
        rightFrame.setDefaultCloseOperation(3);
        rightFrame.setVisible(true);
        JFrame leftFrame = new JFrame("Glimpse Example (Frame B)");
        leftFrame.add((Component)leftPanel);
        leftFrame.pack();
        leftFrame.setSize(800, 800);
        leftFrame.setLocation(0, 0);
        leftFrame.setDefaultCloseOperation(3);
        leftFrame.setVisible(true);
    }
}

